/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee10.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebXmlConfiguration.class);
    public static final String PROPERTY_WEB_INF_URI = "web-inf.uri";
    public static final String PROPERTY_WEB_INF = "web-inf";
    public static final String XML_CONFIGURATION = "org.eclipse.jetty.webapp.JettyWebXmlConfiguration";
    public static final String JETTY_WEB_XML = "jetty-web.xml";
    public static final String JETTY_EE10_WEB_XML = "jetty-ee10-web.xml";

    public JettyWebXmlConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(WebXmlConfiguration.class, FragmentConfiguration.class, MetaInfConfiguration.class));
    }

    @Override
    public void configure(WebAppContext context2) throws Exception {
        Resource webInf;
        Resource jetty;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring web-jetty.xml");
        }
        if (Resources.isReadableFile(jetty = this.resolveJettyWebXml(webInf = context2.getWebInf()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configure: {}", (Object)jetty);
            }
            Object xmlAttr = context2.getAttribute(XML_CONFIGURATION);
            context2.removeAttribute(XML_CONFIGURATION);
            XmlConfiguration jetty_config = xmlAttr instanceof XmlConfiguration ? (XmlConfiguration)xmlAttr : new XmlConfiguration(jetty);
            this.setupXmlConfiguration(context2, jetty_config, webInf);
            try {
                WebAppClassLoader.runWithServerClassAccess(() -> {
                    jetty_config.configure(context2);
                    return null;
                });
            }
            catch (Exception e2) {
                LOG.warn("Error applying {}", (Object)jetty);
                throw e2;
            }
        }
    }

    private Resource resolveJettyWebXml(Resource webInf) {
        String xmlFile = JETTY_EE10_WEB_XML;
        try {
            if (webInf == null || !webInf.isDirectory()) {
                return null;
            }
            Resource jetty = webInf.resolve(xmlFile);
            if (!Resources.missing(jetty)) {
                return jetty;
            }
            xmlFile = JETTY_WEB_XML;
            jetty = webInf.resolve(xmlFile);
            if (!Resources.missing(jetty)) {
                return jetty;
            }
            return null;
        }
        catch (Exception e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error resolving WEB-INF/" + xmlFile, e2);
            }
            return null;
        }
    }

    private void setupXmlConfiguration(WebAppContext context2, XmlConfiguration jettyConfig, Resource webInf) throws IOException {
        jettyConfig.setJettyStandardIdsAndProperties(context2.getServer(), null);
        Map<String, String> props = jettyConfig.getProperties();
        props.put(PROPERTY_WEB_INF_URI, XmlConfiguration.normalizeURI(webInf.getURI().toString()));
        props.put(PROPERTY_WEB_INF, webInf.toString());
    }
}

