/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.filters;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.ee.filters.FormAuthenticationFilter;
import org.apache.shiro.ee.filters.FormResubmitSupport;
import org.apache.shiro.ee.filters.Forms;
import org.apache.shiro.ee.filters.LogoutFilter;
import org.apache.shiro.ee.listeners.EnvironmentLoaderListener;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;

class AuthenticationFilterDelegate {
    private final MethodsFromFilter methods;
    private boolean useRemembered;
    private int loginFailedWaitTime;
    private Forms.FallbackPredicate loginFallbackType = FormAuthenticationFilter.NO_PREDICATE;
    private Forms.FallbackPredicate logoutFallbackType = LogoutFilter.YES_PREDICATE;

    public boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        request.setAttribute("org.apache.shiro.ee.login-predicate", this.loginFallbackType);
        request.setAttribute("org.apache.shiro.ee.login-wait-time", this.loginFailedWaitTime);
        request.setAttribute("org.apache.shiro.ee.logout-predicate", this.logoutFallbackType);
        if (EnvironmentLoaderListener.isServletNoPrincipal(request.getServletContext())) {
            request.setAttribute("org.apache.shiro.web.jaxrs.disable-principal", Boolean.TRUE);
        }
        try {
            request.setAttribute("org.apache.shiro.ee.login-url", this.methods.getLoginUrl());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return this.methods.preHandle(request, response);
    }

    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Subject subject = this.methods.getSubject(request, response);
        boolean isAuthenticated = subject.isAuthenticated() && subject.getPrincipal() != null;
        return isAuthenticated || this.useRemembered && subject.isRemembered();
    }

    public void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        if (request instanceof HttpServletRequest && !EnvironmentLoaderListener.isFormResubmitDisabled(request.getServletContext())) {
            FormResubmitSupport.savePostDataForResubmit(WebUtils.toHttp(request), WebUtils.toHttp(response), this.methods.getLoginUrl());
        }
    }

    public boolean isLoginRequest(ServletRequest request, ServletResponse response) {
        boolean rv = this.methods.isLoginRequest(request, response);
        if (request instanceof HttpServletRequest) {
            FormResubmitSupport.saveRequestReferer(rv, WebUtils.toHttp(request), WebUtils.toHttp(response));
        }
        return rv;
    }

    public boolean onLoginFailure(AuthenticationToken token, AuthenticationException e2, ServletRequest request, ServletResponse response) {
        if (this.loginFailedWaitTime != 0) {
            TimeUnit.SECONDS.sleep(this.loginFailedWaitTime);
        }
        return this.methods.onLoginFailure(token, e2, request, response);
    }

    public void saveRequestAndRedirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        if (request instanceof HttpServletRequest) {
            FormResubmitSupport.saveRequest(WebUtils.toHttp(request), WebUtils.toHttp(response), false);
        }
        this.redirectToLogin(request, response);
    }

    public void saveRequest(ServletRequest request) {
        throw new UnsupportedOperationException("bad op");
    }

    @Generated
    public AuthenticationFilterDelegate(MethodsFromFilter methods) {
        this.methods = methods;
    }

    @Generated
    public boolean isUseRemembered() {
        return this.useRemembered;
    }

    @Generated
    public void setUseRemembered(boolean useRemembered) {
        this.useRemembered = useRemembered;
    }

    @Generated
    public int getLoginFailedWaitTime() {
        return this.loginFailedWaitTime;
    }

    @Generated
    public void setLoginFailedWaitTime(int loginFailedWaitTime) {
        this.loginFailedWaitTime = loginFailedWaitTime;
    }

    @Generated
    public Forms.FallbackPredicate getLoginFallbackType() {
        return this.loginFallbackType;
    }

    @Generated
    public void setLoginFallbackType(Forms.FallbackPredicate loginFallbackType) {
        this.loginFallbackType = loginFallbackType;
    }

    @Generated
    public Forms.FallbackPredicate getLogoutFallbackType() {
        return this.logoutFallbackType;
    }

    @Generated
    public void setLogoutFallbackType(Forms.FallbackPredicate logoutFallbackType) {
        this.logoutFallbackType = logoutFallbackType;
    }

    static interface MethodsFromFilter {
        public Subject getSubject(ServletRequest var1, ServletResponse var2);

        public boolean isLoginRequest(ServletRequest var1, ServletResponse var2);

        public String getLoginUrl();

        public boolean preHandle(ServletRequest var1, ServletResponse var2) throws Exception;

        public boolean onLoginFailure(AuthenticationToken var1, AuthenticationException var2, ServletRequest var3, ServletResponse var4);
    }
}

