/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1;

import java.io.File;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb1.assembler.VocabTDB1;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.setup.StoreParams;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.sys.StoreConnection;
import org.apache.jena.tdb1.sys.TDBInternal;
import org.apache.jena.tdb1.sys.TDBMaker;
import org.apache.jena.tdb1.transaction.DatasetGraphTransaction;

public class TDB1Factory {
    private TDB1Factory() {
    }

    public static Dataset assembleDataset(String assemblerFile) {
        return (Dataset)AssemblerUtils.build(assemblerFile, VocabTDB1.tDatasetTDB);
    }

    public static Dataset createDataset(String dir) {
        return TDB1Factory.createDataset(Location.create(dir));
    }

    public static Dataset createDataset(Location location) {
        return TDB1Factory.createDataset(TDB1Factory.createDatasetGraph(location));
    }

    public static Dataset createDataset() {
        return TDB1Factory.createDataset(TDB1Factory.createDatasetGraph());
    }

    private static Dataset createDataset(DatasetGraph datasetGraph) {
        return DatasetFactory.wrap(datasetGraph);
    }

    public static DatasetGraph createDatasetGraph(String directory) {
        return TDB1Factory.createDatasetGraph(Location.create(directory));
    }

    public static DatasetGraph createDatasetGraph(Location location) {
        return TDB1Factory._createDatasetGraph(location);
    }

    public static DatasetGraph createDatasetGraph() {
        return TDB1Factory._createDatasetGraph();
    }

    public static void release(Dataset dataset) {
        TDB1Factory.release(dataset.asDatasetGraph());
    }

    public static void release(DatasetGraph dataset) {
        TDB1Factory._release(dataset);
    }

    private static void _release(DatasetGraph dataset) {
        TDBInternal.expel(dataset);
    }

    private static DatasetGraph _createDatasetGraph(Location location) {
        return TDBMaker.createDatasetGraphTransaction(location);
    }

    private static DatasetGraph _createDatasetGraph() {
        return TDBMaker.createDatasetGraphTransaction();
    }

    public static boolean isTDB1(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        return TDB1Factory.isTDB1(dsg);
    }

    public static boolean isTDB1(DatasetGraph datasetGraph) {
        return TDBInternal.isTDB1(datasetGraph);
    }

    public static Location location(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        return TDB1Factory.location(dsg);
    }

    public static Location location(DatasetGraph datasetGraph) {
        if (datasetGraph instanceof DatasetGraphTDB) {
            DatasetGraphTDB dsgt = (DatasetGraphTDB)datasetGraph;
            return dsgt.getLocation();
        }
        if (datasetGraph instanceof DatasetGraphTransaction) {
            DatasetGraphTransaction dsgtxn = (DatasetGraphTransaction)datasetGraph;
            return dsgtxn.getLocation();
        }
        return null;
    }

    public static boolean inUseLocation(String directory) {
        return TDB1Factory.inUseLocation(Location.create(directory));
    }

    public static boolean inUseLocation(Location location) {
        if (location.isMemUnique()) {
            return false;
        }
        if (location.isMem()) {
            return StoreConnection.getExisting(location) != null;
        }
        String dirname = location.getDirectoryPath();
        File d = new File(dirname);
        if (!d.exists()) {
            return !FileOps.exists(d.getParent());
        }
        return !TDBInternal.isNewDatabaseArea(location);
    }

    public static void setup(Location location, StoreParams params) {
        StoreConnection sConn = StoreConnection.getExisting(location);
        if (sConn != null) {
            throw new IllegalStateException("Location is already active");
        }
        StoreConnection.make(location, params);
    }

    static {
        JenaSystem.init();
    }
}

