/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;

public class TransformElementLib {
    public static Var applyVar(Var v, ExprTransform exprTransform) {
        if (exprTransform == null) {
            return v;
        }
        ExprVar expr = new ExprVar(v);
        Expr e2 = exprTransform.transform(expr);
        if (e2 instanceof ExprVar) {
            return ((ExprVar)e2).asVar();
        }
        throw new InternalErrorException("Managed to turn an assigned variable " + v + " into " + e2);
    }

    public static Node apply(Node n, ExprTransform exprTransform) {
        if (exprTransform == null) {
            return n;
        }
        Expr e2 = null;
        if (Var.isVar(n)) {
            Var v = Var.alloc(n);
            ExprVar expr = new ExprVar(v);
            e2 = exprTransform.transform(expr);
        } else {
            NodeValue nv = NodeValue.makeNode(n);
            e2 = exprTransform.transform(nv);
        }
        if (e2 instanceof ExprVar) {
            return ((ExprVar)e2).asVar();
        }
        if (e2 instanceof NodeValue) {
            return ((NodeValue)e2).asNode();
        }
        throw new InternalErrorException("Managed to turn a node " + n + " into " + e2);
    }

    public static Map<Var, Node> convert(Map<String, ? extends RDFNode> substitutions) {
        return substitutions.entrySet().stream().collect(Collectors.toMap(e2 -> Var.alloc((String)e2.getKey()), e2 -> ((RDFNode)e2.getValue()).asNode()));
    }
}

