/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetWriter;
import org.apache.jena.riot.rowset.RowSetWriterFactory;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetRewindable;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.FmtUtils;

public class RowSetWriterText
implements RowSetWriter {
    public static RowSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_Text)) {
            throw new ResultSetException("RowSetWriter for Text asked for a " + lang);
        }
        return new RowSetWriterText();
    };
    private static final String NL = "\n";
    private static final String notThere = " ";

    private RowSetWriterText() {
    }

    @Override
    public void write(OutputStream out, RowSet resultSet, Context context2) {
        RowSetWriterText.output(IO.wrapUTF8(out), resultSet, context2);
    }

    @Override
    public void write(Writer out, RowSet resultSet, Context context2) {
        RowSetWriterText.output(IO.wrap(out), resultSet, context2);
    }

    @Override
    public void write(OutputStream out, boolean result, Context context2) {
        this.output(IO.wrapUTF8(out), result, context2);
    }

    private void output(AWriter out, boolean result, Context context2) {
        if (result) {
            out.write("yes");
        } else {
            out.write("no");
        }
        out.write(NL);
        out.flush();
    }

    private static int[] colWidths(RowSetRewindable rs, SerializationContext context2) {
        int numCols = rs.getResultVars().size();
        int numRows = 0;
        int[] colWidths = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            colWidths[i] = rs.getResultVars().get(i).getVarName().length();
        }
        while (rs.hasNext()) {
            ++numRows;
            Binding rBind = rs.next();
            int col = -1;
            for (Var var : rs.getResultVars()) {
                String rVar = var.getVarName();
                String s = RowSetWriterText.getVarValueAsString(rBind, var, context2);
                if (colWidths[++col] >= s.length()) continue;
                colWidths[col] = s.length();
            }
        }
        rs.reset();
        return colWidths;
    }

    public static void output(AWriter out, RowSet resultSet, String colStart, String colSep, String colEnd) {
        RowSetWriterText.output(out, resultSet, colStart, colSep, colEnd, null);
    }

    public static void output(AWriter out, RowSet resultSet, Context cxt) {
        RowSetWriterText.output(out, resultSet, "| ", " | ", " |", cxt);
    }

    public static void output(AWriter out, RowSet resultSet, String colStart, String colSep, String colEnd, Context cxt) {
        RowSetWriterText.output$(out, resultSet, colStart, colSep, colEnd, cxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void output$(AWriter out, RowSet rowSet, String colStart, String colSep, String colEnd, Context cxt) {
        Prologue prologue = RowSetWriterText.choosePrologue(rowSet, cxt);
        SerializationContext context2 = new SerializationContext(prologue);
        try {
            int i;
            if (rowSet.getResultVars().size() == 0) {
                out.println("==== No variables ====");
            }
            RowSetRewindable resultSetRewindable = rowSet.rewindable();
            int numCols = resultSetRewindable.getResultVars().size();
            int[] colWidths = RowSetWriterText.colWidths(resultSetRewindable, context2);
            String[] row = new String[numCols];
            int lineWidth = 0;
            for (int col = 0; col < numCols; ++col) {
                String rVar;
                row[col] = rVar = rowSet.getResultVars().get(col).getVarName();
                lineWidth += colWidths[col];
                if (col <= 0) continue;
                lineWidth += colSep.length();
            }
            if (colStart != null) {
                lineWidth += colStart.length();
            }
            if (colEnd != null) {
                lineWidth += colEnd.length();
            }
            for (i = 0; i < lineWidth; ++i) {
                out.print('-');
            }
            out.println();
            RowSetWriterText.printRow(out, row, colWidths, colStart, colSep, colEnd);
            for (i = 0; i < lineWidth; ++i) {
                out.print('=');
            }
            out.println();
            while (resultSetRewindable.hasNext()) {
                Binding rBind = resultSetRewindable.next();
                for (int col = 0; col < numCols; ++col) {
                    Var var = rowSet.getResultVars().get(col);
                    row[col] = RowSetWriterText.getVarValueAsString(rBind, var, context2);
                }
                RowSetWriterText.printRow(out, row, colWidths, colStart, colSep, colEnd);
            }
            for (i = 0; i < lineWidth; ++i) {
                out.print('-');
            }
            out.println();
            resultSetRewindable = null;
        }
        finally {
            out.flush();
        }
    }

    private static void printRow(AWriter out, String[] row, int[] colWidths, String rowStart, String colSep, String rowEnd) {
        out.print(rowStart);
        for (int col = 0; col < colWidths.length; ++col) {
            String s = row[col];
            int pad = colWidths[col];
            StringBuilder sbuff = new StringBuilder(120);
            if (col > 0) {
                sbuff.append(colSep);
            }
            sbuff.append(s);
            for (int j = 0; j < pad - s.length(); ++j) {
                sbuff.append(' ');
            }
            out.print(sbuff.toString());
        }
        out.print(rowEnd);
        out.println();
    }

    private static String getVarValueAsString(Binding rBind, Var var, SerializationContext context2) {
        Node obj = rBind.get(var);
        if (obj == null) {
            return notThere;
        }
        return FmtUtils.stringForNode(obj, context2);
    }

    private static Prologue choosePrologue(RowSet resultSet, Context context2) {
        try {
            if (context2 != null && context2.get(ARQConstants.symPrologue) != null) {
                return (Prologue)context2.get(ARQConstants.symPrologue);
            }
        }
        catch (Exception ex) {
            FmtLog.warn(ARQ.getExecLogger(), "Failed to establish a 'Prologue' for text output: %s", ex.getMessage());
        }
        return null;
    }
}

