/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.impl.Generator;
import org.apache.jena.reasoner.rulesys.impl.LPAgendaEntry;
import org.apache.jena.reasoner.rulesys.impl.LPInterpreter;
import org.apache.jena.reasoner.rulesys.impl.LPInterpreterContext;
import org.apache.jena.reasoner.rulesys.impl.LPRuleStore;
import org.apache.jena.reasoner.rulesys.impl.LPTopGoalIterator;
import org.apache.jena.reasoner.rulesys.impl.RuleClauseCode;
import org.apache.jena.util.SystemUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LPBRuleEngine {
    protected LPRuleStore ruleStore;
    protected BackwardRuleInfGraphI infGraph;
    protected boolean traceOn = false;
    protected boolean recordDerivations;
    protected Collection<LPInterpreter> activeInterpreters = new HashSet<LPInterpreter>();
    protected final int MAX_CACHED_TABLED_GOALS = Integer.parseInt(SystemUtils.getSystemProperty("jena.rulesys.lp.max_cached_tabled_goals", "524288"));
    Cache<TriplePattern, Generator> tabledGoals = CacheFactory.createCache(this.MAX_CACHED_TABLED_GOALS);
    protected LinkedList<LPAgendaEntry> agenda = new LinkedList();
    protected HashMap<String, Count> profile;
    public static final int CYCLES_BETWEEN_COMPLETION_CHECK = 3;
    static Logger logger = LoggerFactory.getLogger(LPBRuleEngine.class);

    public LPBRuleEngine(BackwardRuleInfGraphI infGraph, LPRuleStore rules) {
        this.infGraph = infGraph;
        this.ruleStore = rules;
    }

    public LPBRuleEngine(BackwardRuleInfGraphI infGraph) {
        this.infGraph = infGraph;
        this.ruleStore = new LPRuleStore();
    }

    public synchronized ExtendedIterator<Triple> find(TriplePattern goal) {
        LPInterpreter interpreter = new LPInterpreter(this, goal);
        this.activeInterpreters.add(interpreter);
        return WrappedIterator.create(new LPTopGoalIterator(interpreter));
    }

    public synchronized void reset() {
        this.checkSafeToUpdate();
        this.clearCachedTabledGoals();
        this.agenda.clear();
    }

    public synchronized void addRule(Rule rule) {
        this.checkSafeToUpdate();
        if (rule.headLength() > 1) {
            throw new ReasonerException("Backward rules only allowed one head clause");
        }
        this.ruleStore.addRule(rule);
    }

    public synchronized void deleteRule(Rule rule) {
        this.checkSafeToUpdate();
        this.ruleStore.deleteRule(rule);
    }

    public synchronized List<Rule> getAllRules() {
        this.checkSafeToUpdate();
        return this.ruleStore.getAllRules();
    }

    public synchronized void deleteAllRules() {
        this.checkSafeToUpdate();
        this.ruleStore.deleteAllRules();
    }

    public synchronized void halt() {
        ArrayList<LPInterpreter> copy = new ArrayList<LPInterpreter>(this.activeInterpreters);
        for (LPInterpreter aCopy : copy) {
            aCopy.close();
        }
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
    }

    public boolean getDerivationLogging() {
        return this.recordDerivations;
    }

    public LPRuleStore getRuleStore() {
        return this.ruleStore;
    }

    public BackwardRuleInfGraphI getInfGraph() {
        return this.infGraph;
    }

    public synchronized void detach(LPInterpreter engine) {
        this.activeInterpreters.remove(engine);
    }

    public void checkSafeToUpdate() {
        if (!this.activeInterpreters.isEmpty()) {
            ArrayList<LPInterpreterContext> toClose = new ArrayList<LPInterpreterContext>();
            for (LPInterpreter interpreter : this.activeInterpreters) {
                if (!(interpreter.getContext() instanceof LPTopGoalIterator)) continue;
                toClose.add(interpreter.getContext());
            }
            for (LPInterpreterContext aToClose : toClose) {
                ((LPTopGoalIterator)aToClose).close();
            }
        }
    }

    public synchronized void tablePredicate(Node predicate) {
        this.ruleStore.tablePredicate(predicate);
    }

    public synchronized Generator generatorFor(TriplePattern goal, List<RuleClauseCode> clauses) {
        return this.getCachedTabledGoal(goal, g -> {
            LPInterpreter interpreter = new LPInterpreter(this, (TriplePattern)g, clauses, false);
            this.activeInterpreters.add(interpreter);
            Generator generator = new Generator(interpreter, (TriplePattern)g);
            this.schedule(generator);
            return generator;
        });
    }

    public synchronized Generator generatorFor(TriplePattern goal) {
        return this.getCachedTabledGoal(goal, g -> {
            LPInterpreter interpreter = new LPInterpreter(this, (TriplePattern)g, false);
            this.activeInterpreters.add(interpreter);
            Generator generator = new Generator(interpreter, (TriplePattern)g);
            this.schedule(generator);
            return generator;
        });
    }

    protected Generator getCachedTabledGoal(TriplePattern goal, Function<TriplePattern, Generator> callable) {
        return this.tabledGoals.get(goal, callable);
    }

    protected long cachedTabledGoals() {
        return this.tabledGoals.size();
    }

    protected void clearCachedTabledGoals() {
        this.tabledGoals.clear();
    }

    protected synchronized void removeTabledGenerator(Generator generator) {
        Generator tabledGenerator = this.tabledGoals.getIfPresent(generator.goal);
        if (tabledGenerator != null && tabledGenerator == generator) {
            this.tabledGoals.remove(generator.goal);
        }
    }

    public void schedule(LPAgendaEntry state) {
        this.agenda.add(state);
    }

    public void pump(LPInterpreterContext gen) {
        ArrayList<Generator> batch = null;
        batch = new ArrayList<Generator>(3);
        int count = 0;
        while (!gen.isReady()) {
            if (this.agenda.isEmpty()) {
                return;
            }
            LPAgendaEntry next = this.getNextAgendaEntry();
            next.pump();
            batch.add(next.getGenerator());
            if (++count % 3 != 0) continue;
            Generator.checkForCompletions(batch);
            batch.clear();
        }
        if (!batch.isEmpty()) {
            Generator.checkForCompletions(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LPAgendaEntry getNextAgendaEntry() {
        LinkedList<LPAgendaEntry> linkedList = this.agenda;
        synchronized (linkedList) {
            int chosen = this.agenda.size() - 1;
            LPAgendaEntry next = this.agenda.get(chosen);
            this.agenda.remove(chosen);
            return next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForCompletions() {
        ArrayList<Generator> contexts = null;
        Collection<LPInterpreter> collection = this.activeInterpreters;
        synchronized (collection) {
            contexts = new ArrayList<Generator>(this.activeInterpreters.size());
            for (LPInterpreter activeInterpreter : this.activeInterpreters) {
                LPInterpreterContext context2 = activeInterpreter.getContext();
                if (!(context2 instanceof Generator)) continue;
                contexts.add((Generator)context2);
            }
        }
        Generator.checkForCompletions(contexts);
    }

    public void incrementProfile(RuleClauseCode clause) {
        if (this.profile != null) {
            String index = clause.toString();
            Count count = this.profile.get(index);
            if (count == null) {
                this.profile.put(index, new Count(clause).inc());
            } else {
                count.inc();
            }
        }
    }

    public void resetProfile(boolean enable) {
        this.profile = enable ? new HashMap() : null;
    }

    public void printProfile() {
        if (this.profile == null) {
            System.out.println("No profile collected");
        } else {
            ArrayList<Count> counts = new ArrayList<Count>();
            counts.addAll(this.profile.values());
            Collections.sort(counts);
            System.out.println("LP engine rule profile");
            for (Count count : counts) {
                System.out.println(count);
            }
        }
    }

    static class Count
    implements Comparable<Count> {
        protected int count = 0;
        protected RuleClauseCode clause;

        public Count(RuleClauseCode clause) {
            this.clause = clause;
        }

        public int getCount() {
            return this.count;
        }

        public Count inc() {
            ++this.count;
            return this;
        }

        @Override
        public int compareTo(Count other) {
            return this.count < other.count ? -1 : (this.count == other.count ? 0 : 1);
        }

        public String toString() {
            return " " + this.count + "\t - " + this.clause;
        }
    }
}

