/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.reasoner.BaseInfGraph;
import org.apache.jena.reasoner.IllegalParameterException;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.BuiltinRegistry;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.FBRuleInfGraph;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RuleReasoner;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.shared.WrappedIOException;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class FBRuleReasoner
implements RuleReasoner {
    protected ReasonerFactory factory;
    protected List<Rule> rules = new ArrayList<Rule>();
    protected Graph schemaGraph;
    protected boolean recordDerivations = false;
    boolean traceOn = false;
    protected static final boolean cachePreload = true;
    protected InfGraph preload;
    protected Resource configuration;
    protected Capabilities capabilities;

    public FBRuleReasoner(List<Rule> rules) {
        if (rules == null) {
            throw new NullPointerException("null rules");
        }
        this.rules = rules;
    }

    public FBRuleReasoner(ReasonerFactory factory) {
        this(new ArrayList<Rule>(), factory);
    }

    public FBRuleReasoner(ReasonerFactory factory, Resource configuration) {
        this(new ArrayList<Rule>(), factory);
        this.configuration = configuration;
        if (configuration != null) {
            this.loadConfiguration(configuration);
        }
    }

    protected void loadConfiguration(Resource configuration) {
        StmtIterator i = configuration.listProperties();
        while (i.hasNext()) {
            Statement st = i.nextStatement();
            this.doSetRDFNodeParameter(st.getPredicate(), st.getObject());
        }
    }

    public FBRuleReasoner(List<Rule> rules, ReasonerFactory factory) {
        this(rules);
        this.factory = factory;
    }

    protected FBRuleReasoner(List<Rule> rules, Graph schemaGraph, ReasonerFactory factory) {
        this(rules, factory);
        this.schemaGraph = schemaGraph;
    }

    public FBRuleReasoner addRules(List<Rule> rules) {
        ArrayList<Rule> combined = new ArrayList<Rule>(this.rules);
        combined.addAll(rules);
        this.setRules(combined);
        return this;
    }

    @Override
    public Model getReasonerCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    public Graph getBoundSchema() {
        return this.schemaGraph;
    }

    @Override
    public void addDescription(Model configSpec, Resource base) {
        if (this.configuration != null) {
            StmtIterator i = this.configuration.listProperties();
            while (i.hasNext()) {
                Statement st = i.nextStatement();
                configSpec.add(base, st.getPredicate(), st.getObject());
            }
        }
    }

    @Override
    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model caps = this.factory.getCapabilities();
        Resource root2 = caps.getResource(this.factory.getURI());
        return caps.contains(root2, ReasonerVocabulary.supportsP, property);
    }

    @Override
    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBRuleInfGraph graph = new FBRuleInfGraph(this, this.rules, this.getPreload(), tbox);
        graph.prepare();
        FBRuleReasoner fbr = new FBRuleReasoner(this.rules, graph, this.factory);
        fbr.setDerivationLogging(this.recordDerivations);
        fbr.setTraceOn(this.traceOn);
        return fbr;
    }

    @Override
    public Reasoner bindSchema(Model tbox) throws ReasonerException {
        return this.bindSchema(tbox.getGraph());
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        InfGraph schemaArg = this.schemaGraph == null ? this.getPreload() : (FBRuleInfGraph)this.schemaGraph;
        FBRuleInfGraph graph = new FBRuleInfGraph(this, this.rules, schemaArg);
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.traceOn);
        graph.rebind(data);
        return graph;
    }

    @Override
    public void setRules(List<Rule> rules) {
        this.rules = rules;
        this.preload = null;
        if (this.schemaGraph != null) {
            throw new ReasonerException("Cannot change the rule set for a bound rule reasoner.\nSet the rules before calling bindSchema");
        }
    }

    @Override
    public List<Rule> getRules() {
        return this.rules;
    }

    public static List<Rule> loadRules(String fileName) {
        try {
            return Rule.parseRules(Util.loadRuleParserFromResourceFile(fileName));
        }
        catch (WrappedIOException e2) {
            throw new ReasonerException("Can't load rules file: " + fileName, e2.getCause());
        }
    }

    public synchronized void tablePredicate(Node predicate) {
        Rule tablePredicateRule = new Rule("", new ClauseEntry[]{new Functor("table", new Node[]{predicate}, BuiltinRegistry.theRegistry)}, new ClauseEntry[0]);
        this.rules.add(tablePredicateRule);
    }

    protected synchronized InfGraph getPreload() {
        if (this.preload == null) {
            this.preload = new FBRuleInfGraph(this, this.rules, null);
            this.preload.prepare();
        }
        return this.preload;
    }

    @Override
    public void setDerivationLogging(boolean logOn) {
        this.recordDerivations = logOn;
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    @Override
    public void setParameter(Property parameter, Object value) {
        if (!this.doSetParameter(parameter, value)) {
            throw new IllegalParameterException("RuleReasoner does not recognize configuration parameter " + parameter);
        }
        if (this.configuration == null) {
            Model configModel = ModelFactory.createDefaultModel();
            this.configuration = configModel.createResource();
        }
        Util.updateParameter(this.configuration, parameter, value);
    }

    protected boolean doSetRDFNodeParameter(Property parameter, RDFNode value) {
        return value instanceof Resource && this.doSetResourceParameter(parameter, (Resource)value) || value instanceof Literal && this.doSetParameter(parameter, ((Literal)value).getValue()) || this.doSetParameter(parameter, value.toString());
    }

    protected boolean doSetResourceParameter(Property parameter, Resource value) {
        return false;
    }

    protected boolean doSetParameter(Property parameter, Object value) {
        if (parameter.equals(ReasonerVocabulary.PROPderivationLogging)) {
            this.recordDerivations = Util.convertBooleanPredicateArg(parameter, value);
            return true;
        }
        if (parameter.equals(ReasonerVocabulary.PROPtraceOn)) {
            this.traceOn = Util.convertBooleanPredicateArg(parameter, value);
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public Capabilities getGraphCapabilities() {
        return BaseInfGraph.reasonerInfCapabilities;
    }
}

