/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import java.net.http.HttpClient;
import java.util.Objects;
import java.util.function.Function;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.rdflink.LibRDFLink;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkHTTP;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.exec.http.UpdateSendMode;
import org.apache.jena.sys.JenaSystem;

public class RDFLinkHTTPBuilder {
    static String SameAsDestination;
    protected Transactional txnLifecycle = TransactionalLock.createMRPlusSW();
    protected HttpClient httpClient = null;
    protected String destination = null;
    protected String sQuery = SameAsDestination;
    protected String sUpdate = SameAsDestination;
    protected String sGSP = SameAsDestination;
    protected String queryURL = null;
    protected String updateURL = null;
    protected String gspURL = null;
    protected RDFFormat outputQuads = HttpEnv.defaultQuadsFormat;
    protected RDFFormat outputTriples = HttpEnv.defaultTriplesFormat;
    protected String acceptGraph = "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3";
    protected String acceptDataset = "application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.3";
    protected String acceptSelectResult = WebContent.defaultSparqlResultsHeader;
    protected String acceptAskResult = WebContent.defaultSparqlAskHeader;
    protected String acceptSparqlResults = WebContent.defaultSparqlResultsHeader;
    protected boolean parseCheckQueries = true;
    protected boolean parseCheckUpdates = true;
    protected QuerySendMode querySendMode = QuerySendMode.systemDefault;
    protected UpdateSendMode updateSendMode = UpdateSendMode.systemDefault;
    private Function<RDFLinkHTTPBuilder, RDFLink> creator = null;

    protected RDFLinkHTTPBuilder() {
    }

    protected RDFLinkHTTPBuilder(RDFLinkHTTP base) {
        Objects.requireNonNull(base);
        this.txnLifecycle = base.txnLifecycle;
        if (this.txnLifecycle == null) {
            this.txnLifecycle = TransactionalLock.createMRPlusSW();
        }
        this.httpClient = base.httpClient;
        this.destination = base.destination;
        this.sQuery = base.svcQuery;
        this.sUpdate = base.svcUpdate;
        this.sGSP = base.svcGraphStore;
        this.outputQuads = base.outputQuads;
        this.outputTriples = base.outputTriples;
        this.acceptGraph = base.acceptGraph;
        this.acceptDataset = base.acceptDataset;
        this.acceptSelectResult = base.acceptSelectResult;
        this.acceptAskResult = base.acceptAskResult;
        this.parseCheckQueries = base.parseCheckQueries;
        this.parseCheckUpdates = base.parseCheckUpdates;
        this.querySendMode = base.querySendMode;
        this.updateSendMode = base.updateSendMode;
    }

    public RDFLinkHTTPBuilder destination(String destination) {
        Objects.requireNonNull(destination);
        this.destination = destination;
        return this;
    }

    public RDFLinkHTTPBuilder queryOnly() {
        this.sUpdate = null;
        this.sGSP = null;
        return this;
    }

    public RDFLinkHTTPBuilder queryEndpoint(String sQuery) {
        this.sQuery = sQuery;
        return this;
    }

    public RDFLinkHTTPBuilder updateEndpoint(String sUpdate) {
        this.sUpdate = sUpdate;
        return this;
    }

    public RDFLinkHTTPBuilder gspEndpoint(String sGSP) {
        this.sGSP = sGSP;
        return this;
    }

    private RDFLinkHTTPBuilder txnLifecycle(Transactional txnLifecycle) {
        this.txnLifecycle = txnLifecycle;
        return this;
    }

    public RDFLinkHTTPBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public RDFLinkHTTPBuilder quadsFormat(RDFFormat fmtQuads) {
        if (!RDFLanguages.isQuads(fmtQuads.getLang())) {
            throw new RiotException("Not a language for RDF Datasets: " + fmtQuads);
        }
        this.outputQuads = fmtQuads;
        return this;
    }

    public RDFLinkHTTPBuilder quadsFormat(Lang langQuads) {
        Objects.requireNonNull(langQuads);
        if (!RDFLanguages.isQuads(langQuads)) {
            throw new RiotException("Not a language for RDF Datasets: " + langQuads);
        }
        RDFFormat fmt = RDFWriterRegistry.defaultSerialization(langQuads);
        if (fmt == null) {
            throw new RiotException("Language name not recognized: " + langQuads);
        }
        this.quadsFormat(fmt);
        return this;
    }

    public RDFLinkHTTPBuilder quadsFormat(String langQuads) {
        Objects.requireNonNull(langQuads);
        Lang lang = RDFLanguages.nameToLang(langQuads);
        if (lang == null) {
            throw new RiotException("Language name not recognized: " + langQuads);
        }
        this.quadsFormat(lang);
        return this;
    }

    public RDFLinkHTTPBuilder triplesFormat(RDFFormat fmtTriples) {
        if (!RDFLanguages.isTriples(fmtTriples.getLang())) {
            throw new RiotException("Not a language for RDF Graphs: " + fmtTriples);
        }
        this.outputTriples = fmtTriples;
        return this;
    }

    public RDFLinkHTTPBuilder triplesFormat(Lang langTriples) {
        Objects.requireNonNull(langTriples);
        if (!RDFLanguages.isTriples(langTriples)) {
            throw new RiotException("Not a language for RDF triples: " + langTriples);
        }
        RDFFormat fmt = RDFWriterRegistry.defaultSerialization(langTriples);
        if (fmt == null) {
            throw new RiotException("Language name not recognized: " + langTriples);
        }
        this.triplesFormat(fmt);
        return this;
    }

    public RDFLinkHTTPBuilder triplesFormat(String langTriples) {
        Objects.requireNonNull(langTriples);
        Lang lang = RDFLanguages.nameToLang(langTriples);
        if (lang == null) {
            throw new RiotException("Language name not recognized: " + langTriples);
        }
        this.quadsFormat(lang);
        return this;
    }

    public RDFLinkHTTPBuilder acceptHeaderGraph(String acceptGraph) {
        this.acceptGraph = acceptGraph;
        return this;
    }

    public RDFLinkHTTPBuilder acceptHeaderDataset(String acceptDataset) {
        this.acceptDataset = acceptDataset;
        return this;
    }

    public RDFLinkHTTPBuilder acceptHeaderSelectQuery(String acceptSelectHeader) {
        this.acceptSelectResult = acceptSelectHeader;
        return this;
    }

    public RDFLinkHTTPBuilder acceptHeaderAskQuery(String acceptAskHeader) {
        this.acceptAskResult = acceptAskHeader;
        return this;
    }

    public RDFLinkHTTPBuilder acceptHeaderQuery(String acceptHeader) {
        this.acceptSparqlResults = acceptHeader;
        return this;
    }

    public RDFLinkHTTPBuilder parseCheckSPARQL(boolean parseCheck) {
        this.parseCheckQueries = parseCheck;
        this.parseCheckUpdates = parseCheck;
        return this;
    }

    public RDFLinkHTTPBuilder querySendMode(QuerySendMode sendMode) {
        this.querySendMode = sendMode;
        return this;
    }

    public RDFLinkHTTPBuilder updateSendMode(UpdateSendMode sendMode) {
        this.updateSendMode = sendMode;
        return this;
    }

    public RDFLinkHTTPBuilder creator(Function<RDFLinkHTTPBuilder, RDFLink> function) {
        this.creator = function;
        return this;
    }

    public RDFLink build() {
        Objects.requireNonNull(this.txnLifecycle);
        Function<RDFLinkHTTPBuilder, RDFLink> maker = this.creator;
        if (maker == null) {
            maker = b -> b.buildConnection();
        }
        this.queryURL = LibRDFLink.formServiceURL(this.destination, this.sQuery);
        this.updateURL = LibRDFLink.formServiceURL(this.destination, this.sUpdate);
        this.gspURL = LibRDFLink.formServiceURL(this.destination, this.sGSP);
        return maker.apply(this);
    }

    protected RDFLinkHTTP buildConnection() {
        return new RDFLinkHTTP(this.txnLifecycle, this.httpClient, this.destination, this.queryURL, this.updateURL, this.gspURL, this.outputQuads, this.outputTriples, this.acceptDataset, this.acceptGraph, this.acceptSparqlResults, this.acceptSelectResult, this.acceptAskResult, this.parseCheckQueries, this.parseCheckUpdates, this.querySendMode, this.updateSendMode);
    }

    static {
        JenaSystem.init();
        SameAsDestination = "";
    }
}

