/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.webapp;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.cmd.FusekiArgs;
import org.apache.jena.fuseki.metrics.MetricsProvider;
import org.apache.jena.fuseki.metrics.PrometheusMetricsProvider;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.FusekiCoreInfo;
import org.apache.jena.fuseki.server.OperationRegistry;
import org.apache.jena.fuseki.webapp.FusekiEnv;
import org.apache.jena.fuseki.webapp.FusekiWebapp;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.slf4j.Logger;

public class FusekiServerListener
implements ServletContextListener {
    public static FusekiArgs initialSetup = null;
    private boolean initialized = false;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        String x = servletContext.getContextPath();
        if (!x.isEmpty()) {
            Fuseki.configLog.info("Context path = " + x);
        }
        this.serverInitialization(servletContext);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        org.apache.jena.tdb1.sys.TDBInternal.reset();
        TDBInternal.reset();
    }

    private synchronized void serverInitialization(ServletContext servletContext) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        OperationRegistry operationRegistry = OperationRegistry.createStd();
        OperationRegistry.set(servletContext, operationRegistry);
        DataAccessPointRegistry dataAccessPointRegistry = new DataAccessPointRegistry();
        DataAccessPointRegistry.set(servletContext, dataAccessPointRegistry);
        try {
            FusekiWebapp.formatBaseArea();
            if (!FusekiWebapp.serverInitialized) {
                Fuseki.serverLog.error("Failed to initialize : Server not running");
                return;
            }
            if (initialSetup == null) {
                String cfg;
                initialSetup = new FusekiArgs();
                FusekiServerListener.initialSetup.fusekiServerConfigFile = cfg = FusekiEnv.FUSEKI_BASE.resolve("config.ttl").toAbsolutePath().toString();
            }
            if (initialSetup == null) {
                Fuseki.serverLog.error("No configuration");
                throw new FusekiException("No configuration");
            }
            Fuseki.setVerbose(servletContext, FusekiServerListener.initialSetup.verbose);
            FusekiWebapp.initializeDataAccessPoints(dataAccessPointRegistry, initialSetup, FusekiWebapp.dirConfiguration.toString());
            dataAccessPointRegistry.forEach((name, dap) -> {
                dap.getDataService().setEndpointProcessors(operationRegistry);
                dap.getDataService().goActive();
            });
            PrometheusMetricsProvider metricsProvider = new PrometheusMetricsProvider();
            MetricsProvider.setMetricsProvider(servletContext, metricsProvider);
            metricsProvider.dataAccessPointMetrics(metricsProvider, dataAccessPointRegistry);
        }
        catch (Throwable th) {
            Fuseki.serverLog.error("Exception in initialization: {}", (Object)th.getMessage());
            throw th;
        }
        if (FusekiServerListener.initialSetup.quiet) {
            return;
        }
        FusekiServerListener.info(FusekiServerListener.initialSetup.datasetPath, FusekiServerListener.initialSetup.datasetDescription, FusekiServerListener.initialSetup.fusekiServerConfigFile, dataAccessPointRegistry);
    }

    private static void info(String datasetPath, String datasetDescription, String serverConfigFile, DataAccessPointRegistry dapRegistry) {
        Logger log2 = Fuseki.serverLog;
        FusekiCoreInfo.logServerCmdSetup(log2, FusekiServerListener.initialSetup.verbose, dapRegistry, datasetPath, datasetDescription, serverConfigFile, null);
    }
}

