/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.html;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.jena.fuseki.validation.html.ValidatorHtmlLib;
import org.apache.jena.iri3986.provider.IRIProvider3986;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;

public class IRIValidatorHTML {
    static final String paramIRI = "iri";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeHTML(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            String[] args = httpRequest.getParameterValues(paramIRI);
            if (args == null || args.length == 0) {
                httpResponse.sendError(400, "No ?iri= parameter");
            }
            ServletOutputStream outStream = httpResponse.getOutputStream();
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            System.setOut(new PrintStream(outStream));
            System.setErr(new PrintStream(outStream));
            ValidatorHtmlLib.setHeaders(httpResponse);
            outStream.println("<html>");
            ValidatorHtmlLib.printHead(outStream, "Jena IRI Validator Report");
            outStream.println("<body>");
            outStream.println("<h1>IRI Report</h1>");
            ValidatorHtmlLib.startFixed(outStream);
            try {
                boolean first = true;
                IRIProvider3986 provider = new IRIProvider3986();
                for (String iriStr : args) {
                    if (iriStr.startsWith("<") && (iriStr = iriStr.substring(1)).endsWith(">")) {
                        iriStr = iriStr.substring(0, iriStr.length() - 1);
                    }
                    if (!first) {
                        System.out.println();
                    }
                    first = false;
                    try {
                        IRIx iri2 = provider.create(iriStr);
                        System.out.println(iriStr + " ==> " + iri2);
                        if (iri2.isRelative()) {
                            System.out.println("Relative IRI: " + iriStr);
                        }
                        iri2.handleViolations((error, msg) -> {
                            String str2 = ValidatorHtmlLib.htmlQuote(msg);
                            System.out.println(str2);
                        });
                    }
                    catch (IRIException ex) {
                        System.out.println(iriStr);
                        System.out.println("Bad IRI: " + ex.getMessage());
                    }
                }
            }
            finally {
                ValidatorHtmlLib.finishFixed(outStream);
                System.out.flush();
                System.err.flush();
                System.setOut(stdout);
                System.setErr(stdout);
            }
            outStream.println("</body>");
            outStream.println("</html>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

