/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.ctl.ActionCtl;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.webapp.FusekiWebapp;

public class ActionBackupList
extends ActionCtl {
    private static DirectoryStream.Filter<Path> filterVisibleFiles = entry -> {
        File f = entry.toFile();
        return f.isFile() && !f.isHidden();
    };

    @Override
    public void execGet(HttpAction action) {
        this.executeLifecycle(action);
    }

    @Override
    public void execPost(HttpAction action) {
        this.executeLifecycle(action);
    }

    @Override
    public void validate(HttpAction action) {
    }

    @Override
    public void execute(HttpAction action) {
        JsonValue result = this.description(action);
        ServletOps.setNoCache(action);
        ServletOps.sendJsonReponse(action, result);
    }

    private JsonValue description(HttpAction action) {
        if (!Files.isDirectory(FusekiWebapp.dirBackups, new LinkOption[0])) {
            ServletOps.errorOccurred(String.format("[%d] Backup area '%s' is not a directory", action.id, FusekiWebapp.dirBackups));
        }
        ArrayList paths = new ArrayList();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(FusekiWebapp.dirBackups, filterVisibleFiles);){
            stream.forEach(paths::add);
        }
        catch (IOException ex) {
            action.log.error(String.format("[%d] Backup file list :: IOException :: %s", action.id, ex.getMessage()));
            ServletOps.errorOccurred(ex);
        }
        List<String> fileNames = paths.stream().map(p -> p.getFileName().toString()).sorted().toList();
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("top");
        builder.key("backups");
        builder.startArray();
        fileNames.forEach(builder::value);
        builder.finishArray();
        builder.finishObject("top");
        return builder.build();
    }
}

