/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.cmd;

import jakarta.servlet.ServletContext;
import java.net.BindException;
import java.nio.file.Path;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.cmd.FusekiErrorHandler;
import org.apache.jena.fuseki.cmd.JettyServerConfig;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.FusekiCoreInfo;
import org.apache.jena.fuseki.system.FusekiCore;
import org.apache.jena.fuseki.webapp.FusekiEnv;
import org.apache.jena.sys.JenaSystem;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyFusekiWebapp {
    public static JettyFusekiWebapp instance;
    private ServerConnector serverConnector = null;
    private ServerConnector mgtConnector = null;
    private JettyServerConfig serverConfig;
    private Server server = null;
    private ServletContext servletContext = null;
    public static final String baseResource1 = "webapp";
    public static final String baseResource2 = "target/webapp";

    public static void initializeServer(JettyServerConfig config) {
        instance = new JettyFusekiWebapp(config);
    }

    private JettyFusekiWebapp(JettyServerConfig config) {
        this.serverConfig = config;
        this.buildServerWebapp(this.serverConfig.contextPath, this.serverConfig.jettyConfigFile);
        if (this.mgtConnector == null) {
            this.mgtConnector = this.serverConnector;
        }
        if (config.enableCompression) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setHandler(this.server.getHandler());
            this.server.setHandler(gzipHandler);
        }
    }

    public void start() {
        FusekiCoreInfo.logCode(Fuseki.serverLog);
        String host = this.serverConnector.getHost();
        if (host != null) {
            Fuseki.serverLog.info("Incoming connections limited to " + host);
        }
        try {
            this.server.start();
        }
        catch (BindException ex) {
            Fuseki.serverLog.error("SPARQLServer (port=" + this.serverConnector.getPort() + "): Failed to start server: " + ex.getMessage());
            throw new FusekiException("BindException: port=" + this.serverConnector.getPort() + ": Failed to start server: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to start server: " + ex.getMessage(), ex);
            throw new FusekiException("Failed to start server: " + ex.getMessage(), ex);
        }
        String now2 = DateTimeUtils.nowAsString();
        Fuseki.serverLog.info(String.format("Started %s on port %d", now2, this.serverConnector.getPort()));
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        String now2 = DateTimeUtils.nowAsString();
        Fuseki.serverLog.info(String.format("Stopped %s on port %d", now2, this.serverConnector.getPort()));
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("SPARQLServer: Exception while stopping server: " + ex.getMessage(), ex);
        }
    }

    public static WebAppContext createWebApp(String contextPath) {
        FusekiEnv.setEnvironment();
        WebAppContext webapp = new WebAppContext();
        webapp.getContext().getServletContextHandler().setMaxFormContentSize(20000000);
        String baseResource3 = null;
        String baseResource4 = null;
        if (FusekiEnv.FUSEKI_HOME != null) {
            String HOME = FusekiEnv.FUSEKI_HOME.toString();
            baseResource3 = HOME + "/webapp";
            baseResource4 = HOME + "/target/webapp";
        }
        String baseResource = JettyFusekiWebapp.tryBaseResource(baseResource1, null);
        baseResource = JettyFusekiWebapp.tryBaseResource(baseResource2, baseResource);
        baseResource = JettyFusekiWebapp.tryBaseResource(baseResource3, baseResource);
        if ((baseResource = JettyFusekiWebapp.tryBaseResource(baseResource4, baseResource)) == null) {
            if (baseResource3 == null) {
                Fuseki.serverLog.error("Can't find baseResource (tried webapp and target/webapp)");
            } else {
                Fuseki.serverLog.error("Can't find baseResource (tried webapp, target/webapp, " + baseResource3 + " and " + baseResource4 + ")");
            }
            Fuseki.serverLog.error("Failed to start");
            throw new FusekiException("Failed to start");
        }
        String web_xml = baseResource + "/WEB-INF/web.xml";
        if (!FileOps.exists(web_xml)) {
            Fuseki.serverLog.warn("Can't find WEB-INF/web.xml in " + baseResource);
        }
        webapp.setDescriptor(web_xml);
        webapp.setContextPath(contextPath);
        Path absBaseResource = Path.of(baseResource, new String[0]).toAbsolutePath();
        webapp.getContext().getServletContextHandler().setBaseResourceAsPath(absBaseResource);
        webapp.setDisplayName("org.apache.jena.fuseki.Servlet");
        webapp.setParentLoaderPriority(true);
        webapp.setErrorHandler(new FusekiErrorHandler());
        return webapp;
    }

    public static String getenv(String name) {
        String x = System.getenv(name);
        if (x == null) {
            x = System.getProperty(name);
        }
        return x;
    }

    public DataAccessPointRegistry getDataAccessPointRegistry() {
        return DataAccessPointRegistry.get(this.servletContext);
    }

    private static String tryBaseResource(String maybeResourceBase, String currentResourceBase) {
        if (currentResourceBase != null) {
            return currentResourceBase;
        }
        if (maybeResourceBase != null && FileOps.exists(maybeResourceBase)) {
            return maybeResourceBase;
        }
        return currentResourceBase;
    }

    private void buildServerWebapp(String contextPath, String jettyConfig) {
        if (jettyConfig != null) {
            this.configServer(jettyConfig);
        } else {
            this.defaultServerConfig(this.serverConfig.port, this.serverConfig.loopback);
        }
        WebAppContext webapp = JettyFusekiWebapp.createWebApp(contextPath);
        this.servletContext = webapp.getServletContext();
        this.server.setHandler(webapp);
        if (jettyConfig == null && this.serverConfig.authConfigFile != null) {
            JettyFusekiWebapp.security(webapp, this.serverConfig.authConfigFile);
        }
    }

    private static void security(ServletContextHandler context2, String authfile) {
        UserStore userStore = JettyFusekiWebapp.makeUserStore(authfile);
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        DefaultIdentityService identService = new DefaultIdentityService();
        securityHandler.setIdentityService(identService);
        HashLoginService loginService = new HashLoginService("Fuseki Authentication");
        loginService.setUserStore(userStore);
        loginService.setIdentityService(identService);
        securityHandler.setLoginService(loginService);
        BasicAuthenticator authenticator = new BasicAuthenticator();
        securityHandler.setAuthenticator(authenticator);
        securityHandler.setRealmName("Fuseki");
        ConstraintMapping mapping = new ConstraintMapping();
        Constraint.Builder constraintBuilder = new Constraint.Builder();
        constraintBuilder.authorization(Constraint.Authorization.ANY_USER);
        String authName = securityHandler.getAuthenticator().getAuthenticationType();
        constraintBuilder.name(authName);
        Constraint constraint = constraintBuilder.build();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        securityHandler.addConstraintMapping(mapping);
        context2.setSecurityHandler(securityHandler);
        Fuseki.serverLog.debug("Basic Auth Configuration = " + authfile);
    }

    private static UserStore makeUserStore(String passwordFile) {
        if (!FileOps.exists(passwordFile)) {
            throw new FusekiConfigException("No such file: " + passwordFile);
        }
        PropertyUserStore propertyUserStore = new PropertyUserStore();
        Resource pwResource = JettyFusekiWebapp.newResource(passwordFile);
        propertyUserStore.setConfig(pwResource);
        propertyUserStore.setReloadInterval(5);
        try {
            propertyUserStore.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("UserStore", ex);
        }
        return propertyUserStore;
    }

    private static Resource newResource(String filename) {
        return ResourceFactory.root().newResource(filename);
    }

    private void defaultServerConfig(int port, boolean loopback) {
        this.server = new Server();
        HttpConnectionFactory f1 = new HttpConnectionFactory();
        f1.getHttpConfiguration().setRequestHeaderSize(524288);
        f1.getHttpConfiguration().setOutputBufferSize(0x500000);
        if (!Fuseki.outputJettyServerHeader) {
            f1.getHttpConfiguration().setSendServerVersion(false);
        }
        ServerConnector connector = new ServerConnector(this.server, f1);
        connector.setPort(port);
        this.server.addConnector(connector);
        if (loopback) {
            connector.setHost("localhost");
        }
        this.serverConnector = connector;
    }

    private void configServer(String jettyConfig) {
        try {
            Fuseki.serverLog.info("Jetty server config file = " + jettyConfig);
            this.server = new Server();
            Resource configXml = ResourceFactory.root().newResource(jettyConfig);
            XmlConfiguration configuration = new XmlConfiguration(configXml);
            configuration.configure(this.server);
            this.serverConnector = (ServerConnector)this.server.getConnectors()[0];
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to configure server: " + ex.getMessage(), ex);
            throw new FusekiException("Failed to configure a server using configuration file '" + jettyConfig + "'");
        }
    }

    static {
        JenaSystem.init();
        FusekiCore.init();
        instance = null;
    }
}

