/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cdt;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.cdt.CompositeDatatypeBase;
import org.apache.jena.cdt.ParserForCDTLiterals;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.NodeValue;

public class CompositeDatatypeList
extends CompositeDatatypeBase<List<CDTValue>> {
    public static final String uri = "http://w3id.org/awslabs/neptune/SPARQL-CDTs/List";
    public static final CompositeDatatypeList type = new CompositeDatatypeList();

    protected CompositeDatatypeList() {
    }

    @Override
    public String getURI() {
        return uri;
    }

    @Override
    public boolean isValidValue(Object value) {
        if (!(value instanceof List)) {
            return false;
        }
        List l = (List)value;
        for (Object e2 : l) {
            if (e2 instanceof CDTValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidLiteral(LiteralLabel lit) {
        String dtURI = lit.getDatatypeURI();
        if (dtURI == null || !dtURI.equals(uri)) {
            return false;
        }
        String lang = lit.language();
        if (lang != null && !lang.isEmpty()) {
            return false;
        }
        String lex = lit.getLexicalForm();
        return this.isValid(lex);
    }

    @Override
    public boolean isValid(String lexicalForm) {
        try {
            ParserForCDTLiterals.parseListLiteral(lexicalForm);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public List<CDTValue> parse(String lexicalForm) throws DatatypeFormatException {
        try {
            return ParserForCDTLiterals.parseListLiteral(lexicalForm);
        }
        catch (Exception ex) {
            throw new DatatypeFormatException(lexicalForm, (RDFDatatype)type, ex);
        }
    }

    @Override
    public String unparse(Object value) {
        if (!(value instanceof List)) {
            throw new IllegalArgumentException();
        }
        List list = (List)value;
        return this.unparseValue(list);
    }

    @Override
    public String unparseValue(List<CDTValue> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (!list.isEmpty()) {
            Iterator<CDTValue> it = list.iterator();
            CDTValue firstElmt = it.next();
            String firstElmtAsString = this.unparseListElement(firstElmt);
            sb.append(firstElmtAsString);
            while (it.hasNext()) {
                CDTValue nextElmt = it.next();
                String nextElmtAsString = this.unparseListElement(nextElmt);
                sb.append(", ");
                sb.append(nextElmtAsString);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    protected String unparseListElement(CDTValue elmt) {
        return elmt.asLexicalForm();
    }

    @Override
    public int getHashCode(LiteralLabel lit) {
        return lit.hashCode();
    }

    @Override
    public boolean isEqual(LiteralLabel value1, LiteralLabel value2) {
        if (!CompositeDatatypeList.isListLiteral(value1) || !CompositeDatatypeList.isListLiteral(value2)) {
            return false;
        }
        List<CDTValue> list1 = CompositeDatatypeList.getValue(value1);
        List<CDTValue> list2 = CompositeDatatypeList.getValue(value2);
        if (list1.size() != list2.size()) {
            return false;
        }
        if (list1.isEmpty()) {
            return true;
        }
        Iterator<CDTValue> it1 = list1.iterator();
        Iterator<CDTValue> it2 = list2.iterator();
        while (it1.hasNext()) {
            CDTValue v1 = it1.next();
            CDTValue v2 = it2.next();
            if (v1.isNull() || v2.isNull()) {
                if (v1.isNull() && v2.isNull()) continue;
                return false;
            }
            Node n1 = v1.asNode();
            Node n2 = v2.asNode();
            if ((n1.isBlank() || n2.isBlank()) && !n1.equals(n2)) {
                throw new ExprEvalException("blank nodes in lists cannot be compared");
            }
            if (n1.sameValueAs(n2)) continue;
            return false;
        }
        return true;
    }

    public static int compare(LiteralLabel value1, LiteralLabel value2, boolean sortOrderingCompare) throws ExprNotComparableException {
        List<CDTValue> list2;
        List<CDTValue> list1;
        if (!value1.isWellFormed() || !value2.isWellFormed()) {
            throw new ExprNotComparableException("Can't compare " + value1 + " and " + value2);
        }
        try {
            list1 = CompositeDatatypeList.getValue(value1);
            list2 = CompositeDatatypeList.getValue(value2);
        }
        catch (Exception e2) {
            throw new ExprNotComparableException("Can't compare " + value1 + " and " + value2);
        }
        if (list1.isEmpty() || list2.isEmpty()) {
            if (!list1.isEmpty()) {
                return 1;
            }
            if (!list2.isEmpty()) {
                return -1;
            }
            if (sortOrderingCompare) {
                return CompositeDatatypeList.compareByLexicalForms(value1, value2);
            }
            return 0;
        }
        int n = Math.min(list1.size(), list2.size());
        for (int i = 0; i < n; ++i) {
            CDTValue elmt1 = list1.get(i);
            CDTValue elmt2 = list2.get(i);
            if (!elmt1.isNull() && !elmt2.isNull()) {
                NodeValue nv1 = NodeValue.makeNode(elmt1.asNode());
                NodeValue nv2 = NodeValue.makeNode(elmt2.asNode());
                if (!sortOrderingCompare && nv1.isBlank() && nv2.isBlank()) {
                    throw new ExprNotComparableException("Can't compare " + value1 + " and " + value2);
                }
                try {
                    int c = sortOrderingCompare ? NodeValue.compareAlways(nv1, nv2) : NodeValue.compare(nv1, nv2);
                    if (c < 0) {
                        return -1;
                    }
                    if (c > 0) {
                        return 1;
                    }
                }
                catch (Exception c) {
                    // empty catch block
                }
                boolean sameValueTestResult = false;
                boolean sameValueTestFailed = false;
                try {
                    sameValueTestResult = NodeValue.sameValueAs(nv1, nv2);
                }
                catch (Exception e3) {
                    sameValueTestFailed = true;
                }
                if (!sameValueTestFailed && sameValueTestResult) continue;
                if (sortOrderingCompare) {
                    return 2;
                }
                throw new ExprNotComparableException("Can't compare " + value1 + " and " + value2);
            }
            if (!sortOrderingCompare) {
                if (elmt1.isNull() && elmt2.isNull()) continue;
                throw new ExprNotComparableException("Can't compare " + value1 + " and " + value2);
            }
            if (elmt1.isNull() && !elmt2.isNull()) {
                return -1;
            }
            if (!elmt2.isNull() || elmt1.isNull()) continue;
            return 1;
        }
        int sizeDiff = list1.size() - list2.size();
        if (sizeDiff < 0) {
            return -1;
        }
        if (sizeDiff > 0) {
            return 1;
        }
        if (sortOrderingCompare) {
            return CompositeDatatypeList.compareByLexicalForms(value1, value2);
        }
        return 0;
    }

    public static boolean isListLiteral(Node n) {
        return n.isLiteral() && n.getLiteralDatatypeURI().equals(uri);
    }

    public static boolean isListLiteral(LiteralLabel lit) {
        return lit.getDatatypeURI().equals(uri);
    }

    public static List<CDTValue> getValue(LiteralLabel lit) throws DatatypeFormatException {
        Object value = lit.getValue();
        if (value == null || !(value instanceof List)) {
            throw new IllegalArgumentException(lit.toString() + " - " + value);
        }
        List list = (List)value;
        return list;
    }
}

