/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cdt;

import org.apache.jena.cdt.CompositeDatatypeList;
import org.apache.jena.cdt.CompositeDatatypeMap;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.expr.ExprEvalException;

public abstract class CDTValue {
    public boolean isNull() {
        return false;
    }

    public boolean isNode() {
        return false;
    }

    public Node asNode() {
        throw new UnsupportedOperationException(this + " is not an RDF term");
    }

    public String toString() {
        if (this.isNode()) {
            return this.asNode().toString();
        }
        if (this.isNull()) {
            return "null";
        }
        throw new IllegalArgumentException("not null and not a Node (" + this.getClass().getName() + ")");
    }

    public int hashCode() {
        if (this.isNode()) {
            return this.asNode().hashCode();
        }
        if (this.isNull()) {
            return 1;
        }
        throw new IllegalArgumentException("not null and not a Node (" + this.getClass().getName() + ")");
    }

    public boolean equals(Object other) {
        try {
            return this.sameAs(other);
        }
        catch (ExprEvalException ex) {
            return false;
        }
    }

    public boolean sameAs(Object other) throws ExprEvalException {
        if (this.isNull()) {
            throw new ExprEvalException("nulls cannot be compared");
        }
        if (other instanceof CDTValue) {
            CDTValue otherValue = (CDTValue)other;
            if (otherValue.isNull()) {
                throw new ExprEvalException("nulls cannot be compared");
            }
            if (this.isNode()) {
                return otherValue.isNode() && this.asNode().sameValueAs(otherValue.asNode());
            }
            throw new IllegalStateException("unexpected type of CDTValue: " + this.getClass().getName());
        }
        return false;
    }

    public final boolean sameAs(CDTValue otherValue) throws ExprEvalException {
        if (this.isNull()) {
            throw new ExprEvalException("nulls cannot be compared");
        }
        if (otherValue.isNull()) {
            throw new ExprEvalException("nulls cannot be compared");
        }
        if (this.isNode()) {
            return otherValue.isNode() && this.asNode().sameValueAs(otherValue.asNode());
        }
        throw new IllegalStateException("unexpected type of CDTValue: " + this.getClass().getName());
    }

    public String asLexicalForm() {
        if (this.isNull()) {
            return "null";
        }
        if (this.isNode()) {
            Node n = this.asNode();
            if (CompositeDatatypeList.isListLiteral(n)) {
                return n.getLiteralLexicalForm();
            }
            if (CompositeDatatypeMap.isMapLiteral(n)) {
                return n.getLiteralLexicalForm();
            }
            return NodeFmtLib.strTTL(n);
        }
        throw new IllegalStateException("unexpected type of CDTValue: " + this.getClass().getName());
    }
}

