/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.jena.atlas.io.IOX;

public class Host {
    public static String getHostAddress() {
        try {
            InetAddress addr = Host.getLocalHostLANAddress$();
            if (addr == null) {
                return null;
            }
            return addr.getHostAddress();
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    public static InetAddress getLocalHostLANAddress() {
        try {
            return Host.getLocalHostLANAddress$();
        }
        catch (IOException ioException) {
            throw IOX.exception(ioException);
        }
    }

    private static InetAddress getLocalHostLANAddress$() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (UnknownHostException e2) {
            throw e2;
        }
        catch (Exception e3) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e3);
            unknownHostException.initCause(e3);
            throw unknownHostException;
        }
    }
}

