/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.context.cache.Cache;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.Ticker;
import jakarta.json.JsonValue;

public class ProcessingRuntime {
    protected final JsonLdOptions options;

    protected ProcessingRuntime(JsonLdOptions options) {
        this.options = options;
    }

    public static ProcessingRuntime of(JsonLdOptions options) {
        return options.getTimeout() != null ? new Ticker(options) : new ProcessingRuntime(options);
    }

    public void tick() throws JsonLdError {
    }

    public void resetTicker() {
    }

    public boolean isUriValidation() {
        return this.options.isUriValidation();
    }

    public boolean isV10() {
        return this.options.getProcessingMode() != null && this.options.getProcessingMode().equals((Object)JsonLdVersion.V1_0);
    }

    public boolean isV11() {
        return this.options.getProcessingMode() != null && this.options.getProcessingMode().equals((Object)JsonLdVersion.V1_1);
    }

    public DocumentLoader getDocumentLoader() {
        return this.options.getDocumentLoader();
    }

    public Cache<String, JsonValue> getContextCache() {
        return this.options.getContextCache();
    }

    public Cache<String, Document> getDocumentCache() {
        return this.options.getDocumentCache();
    }

    public boolean isRdfStar() {
        return this.options.isRdfStar();
    }

    public boolean isNumericId() {
        return this.options.isNumericId();
    }

    public JsonLdOptions.ProcessingPolicy getUndefinedTermPolicy() {
        return this.options.getUndefinedTermsPolicy();
    }
}

