/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.omnifaces.filter.OnDemandResponseBufferFilter;
import org.omnifaces.util.Platform;
import org.omnifaces.util.cache.CacheFactory;
import org.omnifaces.util.cache.CacheProvider;

public final class CacheInitializer {
    public static final String CACHE_PROVIDER_INIT_PARAM_NAME = "org.omnifaces.CACHE_PROVIDER";
    public static final String CACHE_INSTALL_BUFFER_FILTER = "org.omnifaces.CACHE_INSTALL_BUFFER_FILTER";
    public static final String CACHE_PROVIDER_SETTING_INIT_PARAM_PREFIX = "org.omnifaces.CACHE_SETTING_";

    private CacheInitializer() {
    }

    public static void loadProviderAndRegisterFilter(ServletContext context2) {
        CacheProvider cacheProvider = CacheInitializer.getCacheProvider(context2);
        cacheProvider.setParameters(CacheInitializer.getCacheSetting(context2));
        if (Boolean.parseBoolean(context2.getInitParameter(CACHE_INSTALL_BUFFER_FILTER))) {
            ServletRegistration facesServletRegistration = Platform.getFacesServletRegistration(context2);
            FilterRegistration.Dynamic bufferFilterRegistration = context2.addFilter(OnDemandResponseBufferFilter.class.getName(), OnDemandResponseBufferFilter.class);
            bufferFilterRegistration.addMappingForServletNames(null, true, new String[]{facesServletRegistration.getName()});
        }
    }

    private static CacheProvider getCacheProvider(ServletContext context2) {
        CacheProvider cacheProvider;
        String cacheProviderName = context2.getInitParameter(CACHE_PROVIDER_INIT_PARAM_NAME);
        if (cacheProviderName != null) {
            cacheProvider = CacheInitializer.createInstance(cacheProviderName);
            CacheFactory.setCacheProvider(cacheProvider, context2);
        } else {
            cacheProvider = CacheFactory.getDefaultCacheProvider();
        }
        return cacheProvider;
    }

    private static CacheProvider createInstance(String cacheProviderName) {
        try {
            return (CacheProvider)Class.forName(cacheProviderName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    private static Map<String, String> getCacheSetting(ServletContext context2) {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (String initParameterName : Collections.list(context2.getInitParameterNames())) {
            if (!initParameterName.startsWith(CACHE_PROVIDER_SETTING_INIT_PARAM_PREFIX)) continue;
            settings.put(initParameterName.substring(CACHE_PROVIDER_SETTING_INIT_PARAM_PREFIX.length()), context2.getInitParameter(initParameterName));
        }
        return settings;
    }
}

