/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import javax.servlet.http.Part;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Servlets;

public final class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 10240;
    private static final String PATTERN_RFC1123_DATE = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");
    private static final Pattern PATTERN_ISO639_ISO3166_LOCALE = Pattern.compile("[a-z]{2,3}(_[A-Z]{2})?");
    private static final int UNICODE_3_BYTES = 4095;
    private static final int UNICODE_2_BYTES = 255;
    private static final int UNICODE_1_BYTE = 15;
    private static final int UNICODE_END_PRINTABLE_ASCII = 127;
    private static final int UNICODE_BEGIN_PRINTABLE_ASCII = 32;
    private static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS = Utils.collectPrimitiveDefaults();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPES = Utils.collectPrimitiveTypes();
    private static final String ERROR_UNSUPPORTED_ENCODING = "UTF-8 is apparently not supported on this platform.";
    private static final String ERROR_UNSUPPORTED_DATE = "Only java.util.Date, java.util.Calendar and java.time.Temporal are supported.";
    private static final String ERROR_UNSUPPORTED_TIMEZONE = "Only java.lang.String, java.util.TimeZone and java.time.ZoneId are supported.";

    private Utils() {
    }

    private static Map<Class<?>, Object> collectPrimitiveDefaults() {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> primitiveDefaults = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        primitiveDefaults.put(Boolean.TYPE, Boolean.valueOf(false));
        primitiveDefaults.put(Byte.TYPE, Byte.valueOf((byte)0));
        primitiveDefaults.put(Short.TYPE, Short.valueOf((short)0));
        primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
        primitiveDefaults.put(Integer.TYPE, Integer.valueOf(0));
        primitiveDefaults.put(Long.TYPE, Long.valueOf(0L));
        primitiveDefaults.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaults.put(Double.TYPE, Double.valueOf(0.0));
        return Collections.unmodifiableMap(primitiveDefaults);
    }

    private static Map<Class<?>, Class<?>> collectPrimitiveTypes() {
        HashMap<Class, Class<Comparable<Boolean>>> primitiveTypes = new HashMap<Class, Class<Comparable<Boolean>>>();
        primitiveTypes.put(Boolean.class, Boolean.TYPE);
        primitiveTypes.put(Byte.class, Byte.TYPE);
        primitiveTypes.put(Short.class, Short.TYPE);
        primitiveTypes.put(Character.class, Character.TYPE);
        primitiveTypes.put(Integer.class, Integer.TYPE);
        primitiveTypes.put(Long.class, Long.TYPE);
        primitiveTypes.put(Float.class, Float.TYPE);
        primitiveTypes.put(Double.class, Double.TYPE);
        return Collections.unmodifiableMap(primitiveTypes);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Part part) {
        return part == null || Utils.isEmpty(Servlets.getSubmittedFileName(part)) && part.getSize() <= 0L;
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return Utils.isEmpty((String)value);
        }
        if (value instanceof Collection) {
            return Utils.isEmpty((Collection)value);
        }
        if (value instanceof Map) {
            return Utils.isEmpty((Map)value);
        }
        if (value instanceof Part) {
            return Utils.isEmpty((Part)value);
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return value.toString() == null || value.toString().isEmpty();
    }

    public static boolean isAnyEmpty(Object ... values) {
        for (Object value : values) {
            if (!Utils.isEmpty(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(String string) {
        return Utils.isEmpty(string) || string.trim().isEmpty();
    }

    public static boolean isNumber(String string) {
        try {
            return Long.valueOf(string) != null;
        }
        catch (Exception ignore) {
            logger.log(Level.FINEST, "Ignoring thrown exception; the sole intent is to return false instead.", ignore);
            return false;
        }
    }

    public static boolean isDecimal(String string) {
        try {
            return Double.valueOf(string) != null;
        }
        catch (Exception ignore) {
            logger.log(Level.FINEST, "Ignoring thrown exception; the sole intent is to return false instead.", ignore);
            return false;
        }
    }

    @SafeVarargs
    public static <T> T coalesce(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @SafeVarargs
    public static <T> boolean isOneOf(T object, T ... objects) {
        for (T other : objects) {
            if (!Objects.equals(object, other)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithOneOf(String string, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithOneOf(String string, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!string.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneInstanceOf(Class<?> cls, Class<?> ... classes) {
        for (Class<?> other : classes) {
            if (!(cls == null ? other == null : other.isAssignableFrom(cls))) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean isOneAnnotationPresent(Class<?> cls, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (!cls.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public static Object getDefaultValue(Class<?> cls) {
        return cls.isPrimitive() ? PRIMITIVE_DEFAULTS.get(cls) : null;
    }

    public static Class<?> getPrimitiveType(Class<?> cls) {
        return cls.isPrimitive() ? cls : PRIMITIVE_TYPES.get(cls);
    }

    /*
     * Exception decompiling
     */
    public static long stream(InputStream input, OutputStream output) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long stream(File file, OutputStream output, long start, long length) throws IOException {
        if (start == 0L && length >= file.length()) {
            return Utils.stream(new FileInputStream(file), output);
        }
        try (FileChannel fileChannel = (FileChannel)Files.newByteChannel(file.toPath(), StandardOpenOption.READ);){
            WritableByteChannel outputChannel = Channels.newChannel(output);
            ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
            long size = 0L;
            while (fileChannel.read(buffer, start + size) != -1) {
                buffer.flip();
                if (size + (long)buffer.limit() > length) {
                    buffer.limit((int)(length - size));
                }
                if ((size += (long)outputChannel.write(buffer)) >= length) break;
                buffer.clear();
            }
            long l = size;
            return l;
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Utils.stream(input, output);
        return output.toByteArray();
    }

    public static IOException close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e2) {
                return e2;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSerializable(Object object) {
        try (ObjectOutputStream output = new ObjectOutputStream(new NullOutputStream());){
            output.writeObject(object);
            boolean bl = true;
            return bl;
        }
        catch (IOException ignore) {
            logger.log(Level.FINEST, "Ignoring thrown exception; the sole intent is to return false instead.", ignore);
            return false;
        }
    }

    public static <E> Set<E> unmodifiableSet(Object ... values) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object value : values) {
            if (value instanceof Object[]) {
                for (Object item : (Object[])value) {
                    set.add(item);
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    set.add(item);
                }
                continue;
            }
            set.add(value);
        }
        return Collections.unmodifiableSet(set);
    }

    public static <E> List<E> iterableToList(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        if (iterable instanceof Collection) {
            return new ArrayList((Collection)iterable);
        }
        ArrayList<E> list = new ArrayList<E>();
        Iterator<E> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static List<String> csvToList(String values) {
        return Utils.csvToList(values, ",");
    }

    public static List<String> csvToList(String values, String delimiter) {
        if (Utils.isEmpty(values)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String value : values.split(Pattern.quote(delimiter))) {
            String trimmedValue = value.trim();
            if (Utils.isEmpty(trimmedValue)) continue;
            list.add(trimmedValue);
        }
        return list;
    }

    public static <T> Map<T, T> reverse(Map<T, T> source) {
        HashMap<T, T> target = new HashMap<T, T>();
        for (Map.Entry<T, T> entry : source.entrySet()) {
            target.put(entry.getValue(), entry.getKey());
        }
        return target;
    }

    public static boolean containsByClassName(Collection<?> objects, String className) {
        Class cls = Reflection.toClassOrNull(className);
        for (Object object : objects) {
            if (object.getClass() != cls) continue;
            return true;
        }
        return false;
    }

    public static <T> Stream<T> stream(Object object) {
        if (object == null) {
            return Stream.empty();
        }
        if (object instanceof Iterable) {
            return StreamSupport.stream(((Iterable)object).spliterator(), false);
        }
        if (object instanceof Map) {
            return ((Map)object).entrySet().stream();
        }
        if (object instanceof int[]) {
            return Arrays.stream((int[])object).boxed();
        }
        if (object instanceof long[]) {
            return Arrays.stream((long[])object).boxed();
        }
        if (object instanceof double[]) {
            return Arrays.stream((double[])object).boxed();
        }
        if (object instanceof Object[]) {
            return Arrays.stream((Object[])object);
        }
        if (object instanceof Stream) {
            return (Stream)object;
        }
        return Stream.of(object);
    }

    public static <E> Stream<E> stream(Iterable<E> iterable) {
        return iterable == null ? Stream.empty() : StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <K, V> Stream<Map.Entry<K, V>> stream(Map<K, V> map) {
        return map == null ? Stream.empty() : map.entrySet().stream();
    }

    public static <T> Stream<T> stream(T[] array) {
        return array == null ? Stream.empty() : Arrays.stream(array);
    }

    public static void forEach(Object object, Consumer<? super Object> action) {
        Utils.stream(object).forEach(action);
    }

    public static String formatRFC1123(java.util.Date date2) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_RFC1123_DATE, Locale.US);
        sdf.setTimeZone(TIMEZONE_GMT);
        return sdf.format(date2);
    }

    public static java.util.Date parseRFC1123(String string) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_RFC1123_DATE, Locale.US);
        return sdf.parse(string);
    }

    public static <D> ZoneId getZoneId(D date2) {
        if (date2 == null || date2 instanceof java.util.Date) {
            return ZoneId.systemDefault();
        }
        if (date2 instanceof Calendar) {
            return ((Calendar)date2).getTimeZone().toZoneId();
        }
        if (date2 instanceof Temporal) {
            Temporal temporal = (Temporal)date2;
            if (temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
                return ZoneId.from((Temporal)date2);
            }
            if (temporal.isSupported(ChronoField.CLOCK_HOUR_OF_DAY)) {
                return ZoneId.systemDefault();
            }
            return ZoneOffset.UTC;
        }
        throw new IllegalArgumentException(ERROR_UNSUPPORTED_DATE);
    }

    public static <Z> ZoneId toZoneId(Z timezone2) {
        if (timezone2 == null) {
            return ZoneId.systemDefault();
        }
        if (timezone2 instanceof ZoneId) {
            return (ZoneId)timezone2;
        }
        if (timezone2 instanceof TimeZone) {
            return ((TimeZone)timezone2).toZoneId();
        }
        if (timezone2 instanceof String) {
            return ZoneId.of((String)timezone2);
        }
        throw new IllegalArgumentException(ERROR_UNSUPPORTED_TIMEZONE);
    }

    public static <D> ZonedDateTime toZonedDateTime(D date2) {
        if (date2 == null) {
            return null;
        }
        ZoneId zone = Utils.getZoneId(date2);
        if (date2 instanceof java.util.Date) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(((java.util.Date)date2).getTime()), zone);
        }
        if (date2 instanceof Calendar) {
            return ((Calendar)date2).toInstant().atZone(zone);
        }
        if (date2 instanceof Instant) {
            return ((Instant)date2).atZone(zone);
        }
        if (date2 instanceof ZonedDateTime) {
            return (ZonedDateTime)date2;
        }
        if (date2 instanceof OffsetDateTime) {
            return ((OffsetDateTime)date2).toZonedDateTime();
        }
        if (date2 instanceof LocalDateTime) {
            return ((LocalDateTime)date2).atZone(zone);
        }
        if (date2 instanceof LocalDate) {
            return ((LocalDate)date2).atStartOfDay(zone);
        }
        if (date2 instanceof OffsetTime) {
            return ((OffsetTime)date2).atDate(LocalDate.now()).toZonedDateTime();
        }
        if (date2 instanceof LocalTime) {
            return ((LocalTime)date2).atDate(LocalDate.now()).atZone(zone);
        }
        if (date2 instanceof Temporal) {
            return Utils.fromTemporalToZonedDateTime((Temporal)date2, zone);
        }
        throw new IllegalArgumentException(ERROR_UNSUPPORTED_DATE);
    }

    private static ZonedDateTime fromTemporalToZonedDateTime(Temporal temporal, ZoneId zone) {
        if (temporal.isSupported(ChronoField.INSTANT_SECONDS)) {
            long epoch = temporal.getLong(ChronoField.INSTANT_SECONDS);
            long nano = temporal.getLong(ChronoField.NANO_OF_SECOND);
            return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epoch, nano), zone);
        }
        int year = temporal.isSupported(ChronoField.YEAR) ? temporal.get(ChronoField.YEAR) : 1;
        int month = temporal.isSupported(ChronoField.MONTH_OF_YEAR) ? temporal.get(ChronoField.MONTH_OF_YEAR) : 1;
        int day = temporal.isSupported(ChronoField.DAY_OF_MONTH) ? temporal.get(ChronoField.DAY_OF_MONTH) : 1;
        int hour = temporal.isSupported(ChronoField.HOUR_OF_DAY) ? temporal.get(ChronoField.HOUR_OF_DAY) : 0;
        int minute = temporal.isSupported(ChronoField.MINUTE_OF_HOUR) ? temporal.get(ChronoField.MINUTE_OF_HOUR) : 0;
        int second = temporal.isSupported(ChronoField.SECOND_OF_MINUTE) ? temporal.get(ChronoField.SECOND_OF_MINUTE) : 0;
        int nano = temporal.isSupported(ChronoField.NANO_OF_SECOND) ? temporal.get(ChronoField.NANO_OF_SECOND) : 0;
        return ZonedDateTime.of(year, month, day, hour, minute, second, nano, zone);
    }

    public static <D> D fromZonedDateTime(ZonedDateTime zonedDateTime, Class<?> type) {
        if (zonedDateTime == null) {
            return null;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (D)new Timestamp(zonedDateTime.toInstant().toEpochMilli());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (D)new Date(zonedDateTime.toInstant().toEpochMilli());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (D)new Time(zonedDateTime.toInstant().toEpochMilli());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (D)java.util.Date.from(zonedDateTime.toInstant());
        }
        if (Calendar.class.isAssignableFrom(type)) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(zonedDateTime.getZone()));
            calendar.setTime(java.util.Date.from(zonedDateTime.toInstant()));
            return (D)calendar;
        }
        if (type == Instant.class) {
            return (D)zonedDateTime.toInstant();
        }
        if (type == ZonedDateTime.class) {
            return (D)zonedDateTime;
        }
        if (type == OffsetDateTime.class) {
            return (D)zonedDateTime.toOffsetDateTime();
        }
        if (type == LocalDateTime.class) {
            return (D)zonedDateTime.toLocalDateTime();
        }
        if (type == LocalDate.class) {
            return (D)zonedDateTime.toLocalDate();
        }
        if (type == OffsetTime.class) {
            return (D)zonedDateTime.toOffsetDateTime().toOffsetTime();
        }
        if (type == LocalTime.class) {
            return (D)zonedDateTime.toLocalDateTime().toLocalTime();
        }
        if (Temporal.class.isAssignableFrom(type)) {
            return (D)Utils.fromZonedDateTimeToTemporal(zonedDateTime, type);
        }
        throw new IllegalArgumentException(ERROR_UNSUPPORTED_DATE);
    }

    private static <T extends Temporal> T fromZonedDateTimeToTemporal(ZonedDateTime zonedDateTime, Class<?> type) {
        Optional<Method> converter = Utils.stream(type.getMethods()).filter(method -> Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()) && method.getParameterCount() == 1 && method.getParameterTypes()[0].isAssignableFrom(Temporal.class) && type.isAssignableFrom(method.getReturnType())).findFirst();
        try {
            if (converter.isPresent()) {
                return (T)((Temporal)converter.get().invoke(null, zonedDateTime));
            }
            throw new NoSuchMethodException();
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(ERROR_UNSUPPORTED_DATE, e2);
        }
    }

    public static Locale parseLocale(Object locale) {
        if (locale == null) {
            return null;
        }
        if (locale instanceof Locale) {
            return (Locale)locale;
        }
        String localeString = locale.toString();
        if (PATTERN_ISO639_ISO3166_LOCALE.matcher(localeString).matches()) {
            String[] languageAndCountry = localeString.split("_");
            String language = languageAndCountry[0];
            String country = languageAndCountry.length > 1 ? languageAndCountry[1] : "";
            return new Locale(language, country);
        }
        return Locale.forLanguageTag(localeString);
    }

    public static String serializeURLSafe(String string) {
        if (string == null) {
            return null;
        }
        try {
            ByteArrayInputStream raw = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
            ByteArrayOutputStream deflated = new ByteArrayOutputStream();
            Utils.stream(raw, new DeflaterOutputStream((OutputStream)deflated, new Deflater(9)));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(deflated.toByteArray());
        }
        catch (IOException e2) {
            throw new UnsupportedOperationException(e2);
        }
    }

    public static String unserializeURLSafe(String string) {
        if (string == null) {
            return null;
        }
        try {
            ByteArrayInputStream deflated = new ByteArrayInputStream(Base64.getUrlDecoder().decode(string));
            return new String(Utils.toByteArray(new InflaterInputStream(deflated)), StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e2) {
            throw new UnsupportedOperationException(e2);
        }
        catch (Exception e3) {
            throw new IllegalArgumentException(e3);
        }
    }

    public static String encodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e2) {
            throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ENCODING, e2);
        }
    }

    public static String decodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e2) {
            throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ENCODING, e2);
        }
    }

    public static String encodeURI(String string) {
        if (string == null) {
            return null;
        }
        return Utils.encodeURL(string).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
    }

    public static String formatURLWithQueryString(String url, String queryString) {
        String normalizedURL;
        String string = normalizedURL = url.isEmpty() ? "/" : url;
        if (Utils.isEmpty(queryString)) {
            return normalizedURL;
        }
        return normalizedURL + (normalizedURL.contains("?") ? "&" : "?") + queryString;
    }

    public static String escapeJS(String string, boolean escapeSingleQuote) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (c > '\u0fff') {
                builder.append("\\u").append(Integer.toHexString(c));
                continue;
            }
            if (c > '\u00ff') {
                builder.append("\\u0").append(Integer.toHexString(c));
                continue;
            }
            if (c > '\u007f') {
                builder.append("\\u00").append(Integer.toHexString(c));
                continue;
            }
            if (c < ' ') {
                Utils.escapeJSControlCharacter(builder, c);
                continue;
            }
            Utils.escapeJSASCIICharacter(builder, c, escapeSingleQuote);
        }
        return builder.toString();
    }

    private static void escapeJSControlCharacter(StringBuilder builder, char c) {
        switch (c) {
            case '\b': {
                builder.append('\\').append('b');
                break;
            }
            case '\n': {
                builder.append('\\').append('n');
                break;
            }
            case '\t': {
                builder.append('\\').append('t');
                break;
            }
            case '\f': {
                builder.append('\\').append('f');
                break;
            }
            case '\r': {
                builder.append('\\').append('r');
                break;
            }
            default: {
                if (c > '\u000f') {
                    builder.append("\\u00").append(Integer.toHexString(c));
                    break;
                }
                builder.append("\\u000").append(Integer.toHexString(c));
            }
        }
    }

    private static void escapeJSASCIICharacter(StringBuilder builder, char c, boolean escapeSingleQuote) {
        switch (c) {
            case '\'': {
                if (escapeSingleQuote) {
                    builder.append('\\');
                }
                builder.append('\'');
                break;
            }
            case '\"': {
                builder.append('\\').append('\"');
                break;
            }
            case '\\': {
                builder.append('\\').append('\\');
                break;
            }
            case '/': {
                builder.append('\\').append('/');
                break;
            }
            default: {
                builder.append(c);
            }
        }
    }

    public static URLConnection openConnection(FacesContext context2, Resource resource) {
        try {
            return resource.getURL().openConnection();
        }
        catch (Exception richFacesDoesNotSupportThis) {
            logger.log(Level.FINEST, "Ignoring thrown exception; this can only be caused by a buggy component library.", richFacesDoesNotSupportThis);
            try {
                return new URL(FacesLocal.getRequestDomainURL(context2) + resource.getRequestPath()).openConnection();
            }
            catch (IOException ignore) {
                logger.log(Level.FINEST, "Ignoring thrown exception; cannot handle it at this point, it would be thrown during getInputStream() anyway.", ignore);
                return null;
            }
        }
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

