/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class Lazy<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient T delegate;
    private volatile transient boolean initialized;
    private final Supplier<T> initFunction;
    private final Lock lock = new ReentrantLock();

    public Lazy(SerializableSupplier<T> initFunction) {
        this.initFunction = initFunction;
    }

    public T get() {
        boolean localInitialized = this.initialized;
        if (!localInitialized) {
            this.lock.lock();
            try {
                if (!this.initialized) {
                    this.delegate = this.initFunction.get();
                }
                this.initialized = true;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.delegate;
    }

    public static interface SerializableSupplier<T>
    extends Supplier<T>,
    Serializable {
    }
}

