/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import org.omnifaces.resourcehandler.DefaultResourceHandler;
import org.omnifaces.resourcehandler.RemappedResource;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Lazy;
import org.omnifaces.util.Utils;

public class VersionedResourceHandler
extends DefaultResourceHandler {
    public static final String PARAM_NAME_VERSION = "org.omnifaces.VERSIONED_RESOURCE_HANDLER_VERSION";
    private static final String XHTML_EXTENSION = ".xhtml";
    private static final String VERSION_SUFFIX = "v=";
    private final Lazy<String> versionString = new Lazy(() -> Utils.encodeURL((String)Faces.evaluateExpressionGet(Faces.getInitParameter(PARAM_NAME_VERSION))));

    public VersionedResourceHandler(ResourceHandler wrapped) {
        super(wrapped);
    }

    @Override
    public Resource decorateResource(Resource resource) {
        if (resource == null || Utils.isBlank(this.versionString.get())) {
            return resource;
        }
        String requestPath = resource.getRequestPath();
        if (requestPath.contains("&v=") || requestPath.contains("?v=")) {
            return resource;
        }
        if (!requestPath.contains("/javax.faces.resource")) {
            return resource;
        }
        if (resource.getResourceName().endsWith(XHTML_EXTENSION)) {
            return resource;
        }
        requestPath = requestPath + (requestPath.contains("?") ? (char)'&' : '?') + VERSION_SUFFIX + this.versionString.get();
        return new RemappedResource(resource, requestPath);
    }
}

