/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.facesviews;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.omnifaces.facesviews.FacesViews;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Messages;
import org.omnifaces.util.ResourcePaths;
import org.omnifaces.util.Utils;

public class FacesViewsViewHandler
extends ViewHandlerWrapper {
    private static final Logger logger = Logger.getLogger(FacesViewsViewHandler.class.getName());
    private static final String ERROR_MULTI_VIEW_NOT_CONFIGURED = "MultiViews was not configured for the view id '%s', but path parameters were defined for it.";
    private final boolean extensionless;
    private final boolean lowercasedRequestURI;

    public FacesViewsViewHandler(ViewHandler wrapped) {
        super(wrapped);
        ServletContext servletContext = Faces.getServletContext();
        this.extensionless = FacesViews.isScannedViewsAlwaysExtensionless(servletContext);
        this.lowercasedRequestURI = FacesViews.isLowercasedRequestURI(servletContext);
    }

    public String deriveViewId(FacesContext context2, String viewId) {
        String physicalViewId;
        if (ResourcePaths.isExtensionless(viewId) && (physicalViewId = FacesViews.getMappedResources(Faces.getServletContext()).get(viewId)) != null) {
            return viewId + ResourcePaths.getExtension(physicalViewId);
        }
        return super.deriveViewId(context2, viewId);
    }

    public String getActionURL(FacesContext context2, String viewId) {
        String resourceName;
        String actionURL = super.getActionURL(context2, viewId);
        ServletContext servletContext = FacesLocal.getServletContext(context2);
        Map<String, String> mappedResources = FacesViews.getMappedResources(servletContext);
        String string = resourceName = this.lowercasedRequestURI ? viewId.toLowerCase() : viewId;
        if (mappedResources.containsKey(resourceName) && (this.extensionless || FacesViewsViewHandler.isOriginalViewExtensionless(context2))) {
            String[] uriAndRest = (this.lowercasedRequestURI ? actionURL.replaceFirst(viewId, resourceName) : actionURL).split("(?=[?#;])", 2);
            String uri = FacesViews.stripWelcomeFilePrefix(servletContext, FacesViewsViewHandler.removeExtensionIfNecessary(servletContext, uriAndRest[0], viewId));
            String rest = uriAndRest.length > 1 ? uriAndRest[1] : "";
            String pathInfo = context2.getViewRoot() != null && context2.getViewRoot().getViewId().equals(viewId) ? Utils.coalesce(FacesLocal.getRequestPathInfo(context2), "") : "";
            return (pathInfo.isEmpty() ? uri : ResourcePaths.stripTrailingSlash(uri) + pathInfo) + rest;
        }
        return actionURL;
    }

    public String getBookmarkableURL(FacesContext context2, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        List<String> pathParams = parameters.get("org.omnifaces.pathparam");
        if (Utils.isEmpty(pathParams)) {
            return super.getBookmarkableURL(context2, viewId, parameters, includeViewParams);
        }
        LinkedHashMap<String, List<String>> parametersWithoutPathParams = new LinkedHashMap<String, List<String>>(parameters);
        parametersWithoutPathParams.remove("org.omnifaces.pathparam");
        String bookmarkableURL = super.getBookmarkableURL(context2, viewId, parametersWithoutPathParams, includeViewParams);
        if (FacesViews.isMultiViewsEnabled(FacesLocal.getServletContext(context2), viewId)) {
            String[] uriAndRest = bookmarkableURL.split("(?=[?#;])", 2);
            String uri = FacesViewsViewHandler.removePathInfoIfNecessary(context2, uriAndRest[0]);
            String rest = uriAndRest.length > 1 ? uriAndRest[1] : "";
            String pathInfo = pathParams.stream().filter(Objects::nonNull).map(Utils::encodeURI).collect(Collectors.joining("/", "/", ""));
            return ResourcePaths.stripTrailingSlash(uri) + pathInfo + rest;
        }
        if (FacesLocal.isDevelopment(context2)) {
            String message = String.format(ERROR_MULTI_VIEW_NOT_CONFIGURED, viewId);
            Messages.addGlobalWarn(message, new Object[0]);
            logger.log(Level.WARNING, message);
        }
        return bookmarkableURL;
    }

    private static boolean isOriginalViewExtensionless(FacesContext context2) {
        String originalViewId = (String)FacesLocal.getRequestAttribute(context2, "javax.servlet.forward.servlet_path");
        if (originalViewId == null) {
            originalViewId = (String)FacesLocal.getRequestAttribute(context2, "org.omnifaces.facesviews.original.servlet_path");
        }
        return originalViewId != null && ResourcePaths.isExtensionless(originalViewId);
    }

    private static String removeExtensionIfNecessary(ServletContext servletContext, String uri, String viewId) {
        String viewIdExtension;
        Set<String> extensions = FacesViews.getFacesServletExtensions(servletContext);
        if (!ResourcePaths.isExtensionless(viewId) && !extensions.contains(viewIdExtension = ResourcePaths.getExtension(viewId))) {
            extensions = new HashSet<String>(extensions);
            extensions.add(viewIdExtension);
        }
        for (String extension : extensions) {
            if (!uri.endsWith(extension)) continue;
            return uri.substring(0, uri.length() - extension.length());
        }
        return uri;
    }

    private static String removePathInfoIfNecessary(FacesContext context2, String uri) {
        String pathInfo = FacesLocal.getRequestPathInfo(context2);
        if (pathInfo != null && uri.endsWith(pathInfo)) {
            return uri.substring(0, uri.length() - pathInfo.length());
        }
        return uri;
    }
}

