/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.facesviews;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import org.omnifaces.facesviews.ExtensionAction;
import org.omnifaces.facesviews.FacesViewsForwardingFilter;
import org.omnifaces.facesviews.FacesViewsViewHandler;
import org.omnifaces.facesviews.PathAction;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Platform;
import org.omnifaces.util.ResourcePaths;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;
import org.omnifaces.util.Xml;

public final class FacesViews {
    public static final String WEB_INF_VIEWS = "/WEB-INF/faces-views/";
    public static final String FACES_VIEWS_ENABLED_PARAM_NAME = "org.omnifaces.FACES_VIEWS_ENABLED";
    public static final String FACES_VIEWS_SCAN_PATHS_PARAM_NAME = "org.omnifaces.FACES_VIEWS_SCAN_PATHS";
    public static final String FACES_VIEWS_SCANNED_VIEWS_EXTENSIONLESS_PARAM_NAME = "org.omnifaces.FACES_VIEWS_SCANNED_VIEWS_ALWAYS_EXTENSIONLESS";
    public static final String FACES_VIEWS_EXTENSION_ACTION_PARAM_NAME = "org.omnifaces.FACES_VIEWS_EXTENSION_ACTION";
    public static final String FACES_VIEWS_PATH_ACTION_PARAM_NAME = "org.omnifaces.FACES_VIEWS_PATH_ACTION";
    public static final String FACES_VIEWS_FILTER_AFTER_DECLARED_FILTERS_PARAM_NAME = "org.omnifaces.FACES_VIEWS_FILTER_AFTER_DECLARED_FILTERS";
    public static final String FACES_VIEWS_LOWERCASED_REQUEST_URI_PARAM_NAME = "org.omnifaces.FACES_VIEWS_LOWERCASED_REQUEST_URI";
    public static final String FACES_VIEWS_ORIGINAL_SERVLET_PATH = "org.omnifaces.facesviews.original.servlet_path";
    public static final String FACES_VIEWS_ORIGINAL_PATH_INFO = "org.omnifaces.facesviews.original.path_info";
    private static final String[] RESTRICTED_DIRECTORIES = new String[]{"/WEB-INF/", "/META-INF/", "/resources/"};
    private static final String SCAN_PATHS = "org.omnifaces.facesviews.scan_paths";
    private static final String PUBLIC_SCAN_PATHS = "org.omnifaces.facesviews.public_scan_paths";
    private static final String MULTIVIEWS_PATHS = "org.omnifaces.facesviews.multiviews_paths";
    private static final String FACES_SERVLET_EXTENSIONS = "org.omnifaces.facesviews.faces_servlet_extensions";
    private static final String MAPPED_RESOURCES = "org.omnifaces.facesviews.mapped_resources";
    private static final String REVERSE_MAPPED_RESOURCES = "org.omnifaces.facesviews.reverse_mapped_resources";
    private static final String MULTIVIEWS_RESOURCES = "org.omnifaces.facesviews.multiviews_resources";
    private static final String EXCLUDED_PATHS = "org.omnifaces.facesviews.exclude_paths";
    private static final String ENCOUNTERED_EXTENSIONS = "org.omnifaces.facesviews.encountered_extensions";
    private static final String MAPPED_WELCOME_FILES = "org.omnifaces.facesviews.mapped_welcome_files";
    private static final String MULTIVIEWS_WELCOME_FILE = "org.omnifaces.facesviews.multiviews_welcome_file";
    private static Boolean facesViewsEnabled;
    private static Boolean multiViewsEnabled;

    private FacesViews() {
    }

    public static void registerForwardingFilter(ServletContext servletContext) {
        if (!FacesViews.isFacesViewsEnabled(servletContext)) {
            return;
        }
        FacesViews.scanAndStoreWelcomeFiles(servletContext);
        Map<String, String> collectedViews = FacesViews.scanAndStoreViews(servletContext, true);
        if (collectedViews.isEmpty()) {
            return;
        }
        FilterRegistration.Dynamic filterRegistration = servletContext.addFilter(FacesViewsForwardingFilter.class.getName(), FacesViewsForwardingFilter.class);
        FacesViews.addForwardingFilterMappings(servletContext, collectedViews, (FilterRegistration)filterRegistration);
    }

    private static void addForwardingFilterMappings(ServletContext servletContext, Map<String, String> collectedViews, FilterRegistration filterRegistration) {
        boolean filterAfterDeclaredFilters = Boolean.parseBoolean(servletContext.getInitParameter(FACES_VIEWS_FILTER_AFTER_DECLARED_FILTERS_PARAM_NAME));
        if (FacesViews.hasMultiViewsWelcomeFile(servletContext)) {
            filterRegistration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), filterAfterDeclaredFilters, new String[]{"/*"});
        } else {
            for (String mapping : collectedViews.keySet()) {
                filterRegistration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), filterAfterDeclaredFilters, new String[]{mapping});
            }
            for (String path : FacesViews.getPublicRootPaths(servletContext)) {
                filterRegistration.addMappingForUrlPatterns(null, false, new String[]{path + "*"});
            }
        }
    }

    public static void addFacesServletMappings(ServletContext servletContext) {
        if (!FacesViews.isFacesViewsEnabled(servletContext)) {
            return;
        }
        Set<String> encounteredExtensions = FacesViews.getEncounteredExtensions(servletContext);
        if (Utils.isEmpty(encounteredExtensions)) {
            return;
        }
        HashSet<String> mappings = new HashSet<String>(encounteredExtensions);
        mappings.addAll(FacesViews.getMappedWelcomeFiles(servletContext));
        mappings.addAll(ResourcePaths.filterExtension(FacesViews.getMappedResources(servletContext).keySet()));
        ServletRegistration facesServletRegistration = Platform.getFacesServletRegistration(servletContext);
        if (facesServletRegistration != null) {
            Collection existingMappings = facesServletRegistration.getMappings();
            for (String mapping : mappings) {
                if (existingMappings.contains(mapping)) continue;
                facesServletRegistration.addMapping(new String[]{mapping});
            }
        }
    }

    @Deprecated
    public static void registerViewHander(ServletContext servletContext, Application application) {
        FacesViews.registerViewHandler(servletContext, application);
    }

    public static void registerViewHandler(ServletContext servletContext, Application application) {
        if (FacesViews.isFacesViewsEnabled(servletContext) && !Utils.isEmpty(FacesViews.getEncounteredExtensions(servletContext))) {
            application.setViewHandler((ViewHandler)new FacesViewsViewHandler(application.getViewHandler()));
        }
    }

    static Map<String, String> scanAndStoreViews(ServletContext servletContext, boolean collectExtensions) {
        HashMap<String, String> collectedViews = new HashMap<String, String>();
        HashSet<String> collectedExtensions = new HashSet<String>();
        HashSet<String> excludedPaths = new HashSet<String>();
        for (String[] stringArray : FacesViews.getRootPathsAndExtensions(servletContext)) {
            String rootPath = stringArray[0];
            if (FacesViews.isExcludePath(rootPath)) {
                excludedPaths.add(rootPath.substring(1));
                continue;
            }
            String extension = stringArray[1];
            FacesViews.scanViews(servletContext, rootPath, servletContext.getResourcePaths(rootPath), collectedViews, extension, collectedExtensions);
        }
        collectedViews.keySet().removeIf(collectedView -> excludedPaths.stream().anyMatch(collectedView::startsWith));
        if (!collectedViews.isEmpty()) {
            if (FacesViews.isLowercasedRequestURI(servletContext)) {
                for (Map.Entry entry : new HashSet(collectedViews.entrySet())) {
                    String lowercasedResourceName;
                    String resourceName = (String)entry.getKey();
                    if (resourceName.equals(lowercasedResourceName = resourceName.toLowerCase())) continue;
                    collectedViews.put(lowercasedResourceName, (String)entry.getValue());
                    if (ResourcePaths.isExtensionless(resourceName)) {
                        collectedViews.remove(resourceName);
                        continue;
                    }
                    entry.setValue(null);
                }
            }
            servletContext.setAttribute(MAPPED_RESOURCES, Collections.unmodifiableMap(collectedViews));
            servletContext.setAttribute(REVERSE_MAPPED_RESOURCES, Collections.unmodifiableMap(collectedViews.entrySet().stream().filter(e2 -> ResourcePaths.isExtensionless((String)e2.getKey())).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (l, r) -> l))));
            servletContext.setAttribute(MULTIVIEWS_RESOURCES, Collections.unmodifiableSet(collectedViews.keySet().stream().filter(k -> k.endsWith("/*")).map(v -> v.substring(0, v.length() - 2)).collect(Collectors.toSet())));
            servletContext.setAttribute(EXCLUDED_PATHS, Collections.unmodifiableSet(excludedPaths));
            if (collectExtensions) {
                FacesViews.storeExtensions(servletContext, collectedViews, collectedExtensions);
            }
        }
        return collectedViews;
    }

    private static void scanAndStoreWelcomeFiles(ServletContext servletContext) {
        URL webXml;
        try {
            webXml = Servlets.getWebXmlURL(servletContext);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
        LinkedHashSet<String> mappedWelcomeFiles = new LinkedHashSet<String>();
        for (String welcomeFile : Xml.getNodeTextContents(webXml, "welcome-file-list/welcome-file")) {
            if (!ResourcePaths.isExtensionless(welcomeFile)) continue;
            mappedWelcomeFiles.add(ResourcePaths.addLeadingSlashIfNecessary(ResourcePaths.stripTrailingSlash(welcomeFile)));
        }
        servletContext.setAttribute(MAPPED_WELCOME_FILES, Collections.unmodifiableSet(mappedWelcomeFiles));
    }

    private static Set<String[]> getRootPathsAndExtensions(ServletContext servletContext) {
        HashSet<String[]> rootPaths = (HashSet<String[]>)servletContext.getAttribute(SCAN_PATHS);
        if (rootPaths == null) {
            rootPaths = new HashSet<String[]>();
            rootPaths.add(new String[]{WEB_INF_VIEWS, null});
            TreeSet<Object> multiViewsPaths = new TreeSet<Object>(Collator.getInstance(Locale.ENGLISH));
            for (String rootPath : Utils.csvToList(servletContext.getInitParameter(FACES_VIEWS_SCAN_PATHS_PARAM_NAME))) {
                String[] stringArray;
                boolean multiViews = rootPath.endsWith("/*");
                if (multiViews) {
                    rootPath = rootPath.substring(0, rootPath.lastIndexOf("/*"));
                }
                if (rootPath.contains("*")) {
                    stringArray = rootPath.split(Pattern.quote("*"));
                } else {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = rootPath;
                    stringArray = stringArray2;
                    stringArray2[1] = null;
                }
                String[] rootPathAndExtension = stringArray;
                rootPathAndExtension[0] = FacesViews.normalizeRootPath(rootPathAndExtension[0]);
                rootPaths.add(rootPathAndExtension);
                if (!multiViews) continue;
                multiViewsPaths.add(rootPathAndExtension[0]);
            }
            servletContext.setAttribute(SCAN_PATHS, Collections.unmodifiableSet(rootPaths));
            servletContext.setAttribute(MULTIVIEWS_PATHS, Collections.unmodifiableSet(multiViewsPaths));
        }
        return rootPaths;
    }

    private static void storeExtensions(ServletContext servletContext, Map<String, String> collectedViews, Set<String> collectedExtensions) {
        servletContext.setAttribute(ENCOUNTERED_EXTENSIONS, Collections.unmodifiableSet(collectedExtensions));
        if (!collectedExtensions.isEmpty()) {
            for (String welcomeFile : FacesViews.getMappedWelcomeFiles(servletContext)) {
                if (!FacesViews.isMultiViewsEnabled(servletContext) || !collectedViews.containsKey(welcomeFile + "/*")) continue;
                servletContext.setAttribute(MULTIVIEWS_WELCOME_FILE, (Object)welcomeFile);
            }
        }
    }

    private static Set<String> getPublicRootPaths(ServletContext servletContext) {
        HashSet<String> publicRootPaths = (HashSet<String>)servletContext.getAttribute(PUBLIC_SCAN_PATHS);
        if (publicRootPaths == null) {
            publicRootPaths = new HashSet<String>();
            for (String[] rootPathAndExtension : FacesViews.getRootPathsAndExtensions(servletContext)) {
                String rootPath = rootPathAndExtension[0];
                if (ResourcePaths.isRoot(rootPath) || FacesViews.isExcludePath(rootPath) || Utils.startsWithOneOf(rootPath, RESTRICTED_DIRECTORIES)) continue;
                publicRootPaths.add(rootPath);
            }
            servletContext.setAttribute(PUBLIC_SCAN_PATHS, Collections.unmodifiableSet(publicRootPaths));
        }
        return publicRootPaths;
    }

    private static void scanViews(ServletContext servletContext, String rootPath, Set<String> resourcePaths, Map<String, String> collectedViews, String extensionToScan, Set<String> collectedExtensions) {
        if (Utils.isEmpty(resourcePaths)) {
            return;
        }
        boolean hasMultiViewsWelcomeFile = FacesViews.hasMultiViewsWelcomeFile(servletContext);
        for (String resourcePath : resourcePaths) {
            if (ResourcePaths.isDirectory(resourcePath)) {
                if (!FacesViews.canScanDirectory(rootPath, resourcePath)) continue;
                FacesViews.scanViews(servletContext, rootPath, servletContext.getResourcePaths(resourcePath), collectedViews, extensionToScan, collectedExtensions);
                continue;
            }
            if (!FacesViews.canScanResource(resourcePath, extensionToScan)) continue;
            FacesViews.scanView(servletContext, rootPath, resourcePath, collectedViews, collectedExtensions, hasMultiViewsWelcomeFile);
        }
    }

    private static void scanView(ServletContext servletContext, String rootPath, String resourcePath, Map<String, String> collectedViews, Set<String> collectedExtensions, boolean hasMultiViewsWelcomeFile) {
        String resource = ResourcePaths.stripPrefixPath(rootPath, resourcePath);
        collectedViews.put(resource, resourcePath);
        String extensionlessResource = ResourcePaths.stripExtension(resource);
        String extensionlessResourcePath = ResourcePaths.stripExtension(resourcePath);
        if (FacesViews.isMultiViewsResource(servletContext, extensionlessResourcePath)) {
            collectedViews.put(extensionlessResource + "/*", resourcePath);
        } else {
            if (hasMultiViewsWelcomeFile) {
                collectedViews.put(extensionlessResource + "/", resourcePath);
            }
            collectedViews.put(extensionlessResource, resourcePath);
            for (String facesServletExtension : FacesViews.getFacesServletExtensions(servletContext)) {
                if (resourcePath.endsWith(facesServletExtension)) continue;
                collectedViews.put(extensionlessResource + facesServletExtension, resourcePath);
            }
        }
        if (collectedExtensions != null) {
            collectedExtensions.add("*" + ResourcePaths.getExtension(resourcePath));
        }
    }

    private static String normalizeRootPath(String rootPath) {
        boolean excludePath = FacesViews.isExcludePath(rootPath);
        return ResourcePaths.addTrailingSlashIfNecessary((excludePath ? "!" : "") + ResourcePaths.addLeadingSlashIfNecessary(rootPath.substring(excludePath ? 1 : 0)));
    }

    private static boolean isExcludePath(String rootPath) {
        return rootPath.charAt(0) == '!';
    }

    private static boolean canScanDirectory(String rootPath, String directory) {
        if (!ResourcePaths.isRoot(rootPath)) {
            return true;
        }
        return !Utils.startsWithOneOf(directory, RESTRICTED_DIRECTORIES);
    }

    private static boolean canScanResource(String resource, String extensionToScan) {
        return extensionToScan == null || resource.endsWith(extensionToScan);
    }

    private static boolean isMultiViewsResource(ServletContext servletContext, String resource) {
        if (FacesViews.isMultiViewsEnabled(servletContext)) {
            String path = resource + "/";
            for (String multiviewsPath : FacesViews.getMultiViewsPaths(servletContext)) {
                if (!path.startsWith(multiviewsPath)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasMultiViewsWelcomeFile(ServletContext servletContext) {
        return FacesViews.isMultiViewsEnabled(servletContext) && !FacesViews.getMappedWelcomeFiles(servletContext).isEmpty();
    }

    static ExtensionAction getExtensionAction(ServletContext servletContext) {
        return FacesViews.getEnumInitParameter(servletContext, FACES_VIEWS_EXTENSION_ACTION_PARAM_NAME, ExtensionAction.class, ExtensionAction.REDIRECT_TO_EXTENSIONLESS);
    }

    static PathAction getPathAction(ServletContext servletContext) {
        return FacesViews.getEnumInitParameter(servletContext, FACES_VIEWS_PATH_ACTION_PARAM_NAME, PathAction.class, PathAction.SEND_404);
    }

    static boolean isResourceInPublicPath(ServletContext servletContext, String resource) {
        for (String path : FacesViews.getPublicRootPaths(servletContext)) {
            if (!resource.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    static String getExtensionlessURLWithQuery(HttpServletRequest request, String resource) {
        String queryString = request.getQueryString() == null ? "" : "?" + request.getQueryString();
        String baseURL = Servlets.getRequestBaseURL(request);
        return baseURL.substring(0, baseURL.length() - 1) + ResourcePaths.stripExtension(resource) + queryString;
    }

    static String getMultiViewsWelcomeFile(ServletContext servletContext, Map<String, String> resources, String servletPath) {
        Set<String> mappedWelcomeFiles = FacesViews.getMappedWelcomeFiles(servletContext);
        Path path = Paths.get(servletPath, new String[0]);
        while (path.getParent() != null) {
            for (String mappedWelcomeFile : mappedWelcomeFiles) {
                String subfolderWelcomeFile = path.toString() + mappedWelcomeFile;
                if (!resources.containsKey(subfolderWelcomeFile + "/*")) continue;
                return subfolderWelcomeFile;
            }
            path = path.getParent();
        }
        return FacesViews.getMultiViewsWelcomeFile(servletContext);
    }

    static boolean isScannedViewsAlwaysExtensionless(ServletContext servletContext) {
        String alwaysExtensionless = servletContext.getInitParameter(FACES_VIEWS_SCANNED_VIEWS_EXTENSIONLESS_PARAM_NAME);
        return Utils.isEmpty(alwaysExtensionless) || Boolean.parseBoolean(alwaysExtensionless);
    }

    static boolean isLowercasedRequestURI(ServletContext servletContext) {
        return Boolean.parseBoolean(servletContext.getInitParameter(FACES_VIEWS_LOWERCASED_REQUEST_URI_PARAM_NAME));
    }

    static Set<String> getFacesServletExtensions(ServletContext servletContext) {
        HashSet<String> extensions = (HashSet<String>)servletContext.getAttribute(FACES_SERVLET_EXTENSIONS);
        if (extensions == null) {
            extensions = new HashSet<String>();
            for (String mapping : Platform.getFacesServletMappings(servletContext)) {
                if (!mapping.startsWith("*")) continue;
                extensions.add(mapping.substring(1));
            }
            servletContext.setAttribute(FACES_SERVLET_EXTENSIONS, Collections.unmodifiableSet(extensions));
        }
        return extensions;
    }

    static String getMappedPath(String path) {
        Map<String, String> mappedResources = FacesViews.getMappedResources(Faces.getServletContext());
        return mappedResources != null && mappedResources.containsKey(path) ? mappedResources.get(path) : path;
    }

    private static <E extends Enum<E>> E getEnumInitParameter(ServletContext servletContext, String name, Class<E> type, E defaultValue) {
        String value = servletContext.getInitParameter(name);
        if (Utils.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(type, value.toUpperCase(Locale.US));
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(String.format("Value '%s' is not valid for context parameter '%s'", value, name), e2);
        }
    }

    static Set<String> getMultiViewsPaths(ServletContext servletContext) {
        return (Set)Servlets.getApplicationAttribute(servletContext, MULTIVIEWS_PATHS);
    }

    static Map<String, String> getMappedResources(ServletContext servletContext) {
        return (Map)Servlets.getApplicationAttribute(servletContext, MAPPED_RESOURCES);
    }

    static Map<String, String> getReverseMappedResources(ServletContext servletContext) {
        return (Map)Servlets.getApplicationAttribute(servletContext, REVERSE_MAPPED_RESOURCES);
    }

    static Set<String> getMultiViewsResources(ServletContext servletContext) {
        return (Set)Servlets.getApplicationAttribute(servletContext, MULTIVIEWS_RESOURCES);
    }

    static Set<String> getExcludedPaths(ServletContext servletContext) {
        return (Set)Servlets.getApplicationAttribute(servletContext, EXCLUDED_PATHS);
    }

    static Set<String> getEncounteredExtensions(ServletContext servletContext) {
        return (Set)Servlets.getApplicationAttribute(servletContext, ENCOUNTERED_EXTENSIONS);
    }

    static Set<String> getMappedWelcomeFiles(ServletContext servletContext) {
        return (Set)Servlets.getApplicationAttribute(servletContext, MAPPED_WELCOME_FILES);
    }

    static String getMultiViewsWelcomeFile(ServletContext servletContext) {
        return (String)Servlets.getApplicationAttribute(servletContext, MULTIVIEWS_WELCOME_FILE);
    }

    public static boolean isFacesViewsEnabled(ServletContext servletContext) {
        if (facesViewsEnabled == null) {
            facesViewsEnabled = !"false".equals(servletContext.getInitParameter(FACES_VIEWS_ENABLED_PARAM_NAME));
        }
        return facesViewsEnabled;
    }

    public static boolean isMultiViewsEnabled(ServletContext servletContext) {
        if (multiViewsEnabled == null) {
            multiViewsEnabled = !Utils.isEmpty(FacesViews.getMultiViewsPaths(servletContext));
        }
        return multiViewsEnabled;
    }

    public static boolean isMultiViewsEnabled(HttpServletRequest request) {
        String resource = request.getServletPath();
        if (Utils.isEmpty(resource) && request.getPathInfo() != null) {
            resource = request.getPathInfo();
        }
        return FacesViews.isMultiViewsEnabled(request.getServletContext(), resource);
    }

    public static boolean isMultiViewsEnabled(ServletContext servletContext, String resource) {
        Set<String> multiViewsResources;
        if (!FacesViews.isMultiViewsEnabled(servletContext)) {
            return false;
        }
        String extensionlessResource = ResourcePaths.stripExtension(resource);
        Set<String> excludedPaths = FacesViews.getExcludedPaths(servletContext);
        if (!Utils.isEmpty(excludedPaths)) {
            String path = extensionlessResource + "/";
            if (excludedPaths.stream().anyMatch(path::startsWith)) {
                return false;
            }
        }
        if ((multiViewsResources = FacesViews.getMultiViewsResources(servletContext)) != null && multiViewsResources.contains(extensionlessResource)) {
            return true;
        }
        Map<String, String> mappedResources = FacesViews.getMappedResources(servletContext);
        if (mappedResources != null && mappedResources.containsKey(extensionlessResource)) {
            return false;
        }
        return FacesViews.getMultiViewsWelcomeFile(servletContext) != null;
    }

    public static String stripWelcomeFilePrefix(ServletContext servletContext, String resource) {
        for (String mappedWelcomeFile : FacesViews.getMappedWelcomeFiles(servletContext)) {
            if (!resource.endsWith(mappedWelcomeFile)) continue;
            return ResourcePaths.addTrailingSlashIfNecessary(resource.substring(0, resource.length() - mappedWelcomeFile.length()));
        }
        return resource;
    }

    public static String stripFacesViewsPrefix(String resource) {
        return ResourcePaths.stripPrefixPath(WEB_INF_VIEWS, resource);
    }
}

