/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.omnifaces.util.Hacks;

public class DelegatingVariableMapper
extends VariableMapper {
    private final VariableMapper wrapped;
    private final Map<String, ValueExpression> variables = new HashMap<String, ValueExpression>();

    public DelegatingVariableMapper(VariableMapper wrapped) {
        this.wrapped = wrapped;
    }

    public ValueExpression resolveVariable(String name) {
        if (name.charAt(0) == '@') {
            return this.wrapped.resolveVariable(name.substring(1));
        }
        if (!this.variables.containsKey(name)) {
            return this.wrapped.resolveVariable(name);
        }
        return this.variables.get(name);
    }

    public ValueExpression resolveWrappedVariable(String name) {
        ValueExpression globalVariable;
        ValueExpression wrappedVariable = this.wrapped.resolveVariable(name);
        if (Objects.equals(wrappedVariable, globalVariable = this.variables.get(name))) {
            return null;
        }
        ValueExpression parentVariable = this.wrapped.resolveVariable("@" + name);
        if (Objects.equals(wrappedVariable, parentVariable)) {
            return null;
        }
        return wrappedVariable;
    }

    public ValueExpression setVariable(String name, ValueExpression expression) {
        return this.variables.put(name, expression);
    }

    public ValueExpression setWrappedVariable(String name, ValueExpression expression) {
        ValueExpression previous = this.wrapped.setVariable(name, expression);
        if (expression == null) {
            DelegatingVariableMapper.clearWrappedVariableMapperIfNecessary(this.wrapped, name);
        }
        return previous;
    }

    private static void clearWrappedVariableMapperIfNecessary(VariableMapper mapper, String name) {
        VariableMapper wrapped = Hacks.findWrappedVariableMapper(mapper);
        if (wrapped != null) {
            wrapped.setVariable(name, null);
            DelegatingVariableMapper.clearWrappedVariableMapperIfNecessary(wrapped, name);
        }
    }
}

