/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IO {
    private static final Logger LOG = LoggerFactory.getLogger(IO.class);
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static final int bufferSize = 65536;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copy(Reader in, Writer out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copy(InputStream in, OutputStream out, long byteCount) throws IOException {
        byte[] buffer = new byte[65536];
        if (byteCount >= 0L) {
            int max2;
            int len;
            while (byteCount > 0L && (len = in.read(buffer, 0, max2 = byteCount < 65536L ? (int)byteCount : 65536)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else {
            int len;
            while ((len = in.read(buffer, 0, 65536)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(Reader in, Writer out, long byteCount) throws IOException {
        char[] buffer = new char[65536];
        if (byteCount >= 0L) {
            int len;
            while (byteCount > 0L && (len = byteCount < 65536L ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, 65536)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else if (out instanceof PrintWriter) {
            int len;
            PrintWriter pout = (PrintWriter)out;
            while (!pout.checkError() && (len = in.read(buffer, 0, 65536)) != -1) {
                out.write(buffer, 0, len);
            }
        } else {
            int len;
            while ((len = in.read(buffer, 0, 65536)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(File from, File to) throws IOException {
        if (from.isDirectory()) {
            IO.copyDir(from, to);
        } else {
            IO.copyFile(from, to);
        }
    }

    public static void copyDir(File from, File to) throws IOException {
        File[] files;
        if (to.exists()) {
            if (!to.isDirectory()) {
                throw new IllegalArgumentException(to.toString());
            }
        } else {
            to.mkdirs();
        }
        if ((files = from.listFiles()) != null) {
            for (File file : files) {
                String name = file.getName();
                if (".".equals(name) || "..".equals(name)) continue;
                IO.copy(file, new File(to, name));
            }
        }
    }

    public static void copyDir(Path srcDir, Path destDir, CopyOption ... copyOptions) throws IOException {
        if (!Files.isDirectory(Objects.requireNonNull(srcDir), new LinkOption[0])) {
            throw new IllegalArgumentException("Source is not a directory: " + String.valueOf(srcDir));
        }
        if (!Files.isDirectory(Objects.requireNonNull(destDir), new LinkOption[0])) {
            throw new IllegalArgumentException("Dest is not a directory: " + String.valueOf(destDir));
        }
        try (Stream<Path> sourceStream = Files.walk(srcDir, 20, new FileVisitOption[0]);){
            Iterator iterFiles = sourceStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).iterator();
            while (iterFiles.hasNext()) {
                Path sourceFile = (Path)iterFiles.next();
                URI relativeSrc = srcDir.toUri().relativize(sourceFile.toUri());
                Path destFile = destDir.resolve(relativeSrc.toASCIIString());
                if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                }
                Files.copy(sourceFile, destFile, copyOptions);
            }
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        try (FileInputStream in = new FileInputStream(from);
             FileOutputStream out = new FileOutputStream(to);){
            IO.copy(in, out);
        }
    }

    public static IOException rethrow(Throwable cause) {
        Exception xx;
        if (cause instanceof ExecutionException) {
            xx = (ExecutionException)cause;
            cause = xx.getCause();
        }
        if (cause instanceof CompletionException) {
            xx = (CompletionException)cause;
            cause = xx.getCause();
        }
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof InterruptedException) {
            return (InterruptedIOException)new InterruptedIOException().initCause(cause);
        }
        return new IOException(cause);
    }

    public static String toString(Path path, Charset charset) throws IOException {
        byte[] buf = Files.readAllBytes(path);
        return new String(buf, charset);
    }

    public static String toString(InputStream in) throws IOException {
        return IO.toString(in, (Charset)null);
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        return IO.toString(in, encoding == null ? null : Charset.forName(encoding));
    }

    public static String toString(InputStream in, Charset encoding) throws IOException {
        StringWriter writer = new StringWriter();
        InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        IO.copy(reader, writer);
        return writer.toString();
    }

    public static String toString(Reader in) throws IOException {
        StringWriter writer = new StringWriter();
        IO.copy(in, writer);
        return writer.toString();
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                IO.delete(files[i]);
            }
        }
        return file.delete();
    }

    public static boolean delete(Path path) {
        if (path == null) {
            return false;
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
            return true;
        }
        catch (IOException e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to delete path: {}", (Object)path, (Object)e2);
            }
            return false;
        }
    }

    public static boolean isEmptyDir(File dir) {
        if (dir == null) {
            return true;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        String[] list = dir.list();
        if (list == null) {
            return true;
        }
        return list.length <= 0;
    }

    public static void close(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception x) {
            LOG.trace("IGNORED", x);
        }
    }

    public static void close(Closeable closeable) {
        IO.close((AutoCloseable)closeable);
    }

    public static void close(InputStream is) {
        IO.close((AutoCloseable)is);
    }

    public static void close(OutputStream os) {
        IO.close((AutoCloseable)os);
    }

    public static void close(Reader reader) {
        IO.close((AutoCloseable)reader);
    }

    public static void close(Writer writer) {
        IO.close((AutoCloseable)writer);
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        IO.copy(in, bout);
        return bout.toByteArray();
    }

    public static long write(GatheringByteChannel out, ByteBuffer[] buffers, int offset, int length) throws IOException {
        long wrote;
        long total = 0L;
        block0: while (length > 0 && (wrote = out.write(buffers, offset, length)) != 0L) {
            total += wrote;
            for (int i = offset; i < buffers.length; ++i) {
                if (!buffers[i].hasRemaining()) continue;
                length -= i - offset;
                offset = i;
                continue block0;
            }
            length = 0;
        }
        return total;
    }

    public static File asFile(Object fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (fileObject instanceof File) {
            return (File)fileObject;
        }
        if (fileObject instanceof String) {
            return new File((String)fileObject);
        }
        if (fileObject instanceof Path) {
            return ((Path)fileObject).toFile();
        }
        return null;
    }

    private IO() {
    }
}

