/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.lang.util;

import java.util.Collection;
import org.apache.shiro.lang.ShiroException;
import org.apache.shiro.lang.util.Destroyable;
import org.apache.shiro.lang.util.Initializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LifecycleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleUtils.class);

    public static void init(Object o) throws ShiroException {
        if (o instanceof Initializable) {
            LifecycleUtils.init((Initializable)o);
        }
    }

    public static void init(Initializable initializable) throws ShiroException {
        initializable.init();
    }

    public static void init(Collection c) throws ShiroException {
        if (c == null || c.isEmpty()) {
            return;
        }
        for (Object o : c) {
            LifecycleUtils.init(o);
        }
    }

    public static void destroy(Object o) {
        if (o instanceof Destroyable) {
            LifecycleUtils.destroy((Destroyable)o);
        } else if (o instanceof Collection) {
            LifecycleUtils.destroy((Collection)o);
        }
    }

    public static void destroy(Destroyable d) {
        block3: {
            if (d != null) {
                try {
                    d.destroy();
                }
                catch (Throwable t2) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    String msg = "Unable to cleanly destroy instance [" + String.valueOf(d) + "] of type [" + d.getClass().getName() + "].";
                    LOGGER.debug(msg, t2);
                }
            }
        }
    }

    public static void destroy(Collection c) {
        if (c == null || c.isEmpty()) {
            return;
        }
        for (Object o : c) {
            LifecycleUtils.destroy(o);
        }
    }
}

