/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.quantization;

import java.io.IOException;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.quantization.RandomAccessQuantizedByteVectorValues;
import org.apache.lucene.util.quantization.ScalarQuantizedVectorSimilarity;
import org.apache.lucene.util.quantization.ScalarQuantizer;

public class ScalarQuantizedRandomVectorScorer
extends RandomVectorScorer.AbstractRandomVectorScorer<byte[]> {
    private final byte[] quantizedQuery;
    private final float queryOffset;
    private final RandomAccessQuantizedByteVectorValues values;
    private final ScalarQuantizedVectorSimilarity similarity;

    public static float quantizeQuery(float[] query2, byte[] quantizedQuery, VectorSimilarityFunction similarityFunction, ScalarQuantizer scalarQuantizer) {
        float[] processedQuery = query2;
        if (similarityFunction.equals((Object)VectorSimilarityFunction.COSINE)) {
            float[] queryCopy = ArrayUtil.copyOfSubArray(query2, 0, query2.length);
            VectorUtil.l2normalize(queryCopy);
            processedQuery = queryCopy;
        }
        return scalarQuantizer.quantize(processedQuery, quantizedQuery, similarityFunction);
    }

    public ScalarQuantizedRandomVectorScorer(ScalarQuantizedVectorSimilarity similarityFunction, RandomAccessQuantizedByteVectorValues values, byte[] query2, float queryOffset) {
        super(values);
        this.quantizedQuery = query2;
        this.queryOffset = queryOffset;
        this.similarity = similarityFunction;
        this.values = values;
    }

    public ScalarQuantizedRandomVectorScorer(VectorSimilarityFunction similarityFunction, ScalarQuantizer scalarQuantizer, RandomAccessQuantizedByteVectorValues values, float[] query2) {
        super(values);
        byte[] quantizedQuery = new byte[query2.length];
        float correction = ScalarQuantizedRandomVectorScorer.quantizeQuery(query2, quantizedQuery, similarityFunction, scalarQuantizer);
        this.quantizedQuery = quantizedQuery;
        this.queryOffset = correction;
        this.similarity = ScalarQuantizedVectorSimilarity.fromVectorSimilarity(similarityFunction, scalarQuantizer.getConstantMultiplier());
        this.values = values;
    }

    @Override
    public float score(int node) throws IOException {
        byte[] storedVectorValue = (byte[])this.values.vectorValue(node);
        float storedVectorCorrection = this.values.getScoreCorrectionConstant();
        return this.similarity.score(this.quantizedQuery, this.queryOffset, storedVectorValue, storedVectorCorrection);
    }
}

