/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.knn;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopKnnCollector;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.MultiLeafTopKnnCollector;
import org.apache.lucene.util.hnsw.BlockingFloatHeap;

public class TopKnnCollectorManager
implements KnnCollectorManager {
    private final int k;
    private final BlockingFloatHeap globalScoreQueue;

    public TopKnnCollectorManager(int k, IndexSearcher indexSearcher) {
        boolean isMultiSegments = indexSearcher.getIndexReader().leaves().size() > 1;
        this.k = k;
        this.globalScoreQueue = isMultiSegments ? new BlockingFloatHeap(k) : null;
    }

    @Override
    public TopKnnCollector newCollector(int visitedLimit, LeafReaderContext context2) throws IOException {
        if (this.globalScoreQueue == null) {
            return new TopKnnCollector(this.k, visitedLimit);
        }
        return new MultiLeafTopKnnCollector(this.k, visitedLimit, this.globalScoreQueue);
    }
}

