/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorSimilarityFunction;

abstract class VectorScorer {
    protected final VectorSimilarityFunction similarity;

    static FloatVectorScorer create(LeafReaderContext context2, FieldInfo fi, float[] query2) throws IOException {
        FloatVectorValues values = context2.reader().getFloatVectorValues(fi.name);
        VectorSimilarityFunction similarity = fi.getVectorSimilarityFunction();
        return new FloatVectorScorer(values, query2, similarity);
    }

    static ByteVectorScorer create(LeafReaderContext context2, FieldInfo fi, byte[] query2) throws IOException {
        ByteVectorValues values = context2.reader().getByteVectorValues(fi.name);
        VectorSimilarityFunction similarity = fi.getVectorSimilarityFunction();
        return new ByteVectorScorer(values, query2, similarity);
    }

    VectorScorer(VectorSimilarityFunction similarity) {
        this.similarity = similarity;
    }

    abstract float score() throws IOException;

    abstract boolean advanceExact(int var1) throws IOException;

    private static class FloatVectorScorer
    extends VectorScorer {
        private final float[] query;
        private final FloatVectorValues values;

        protected FloatVectorScorer(FloatVectorValues values, float[] query2, VectorSimilarityFunction similarity) {
            super(similarity);
            this.query = query2;
            this.values = values;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            int vectorDoc = this.values.docID();
            if (vectorDoc < doc) {
                vectorDoc = this.values.advance(doc);
            }
            return vectorDoc == doc;
        }

        @Override
        public float score() throws IOException {
            assert (this.values.docID() != -1) : this.getClass().getSimpleName() + " is not positioned";
            return this.similarity.compare(this.query, this.values.vectorValue());
        }
    }

    private static class ByteVectorScorer
    extends VectorScorer {
        private final byte[] query;
        private final ByteVectorValues values;

        protected ByteVectorScorer(ByteVectorValues values, byte[] query2, VectorSimilarityFunction similarity) {
            super(similarity);
            this.values = values;
            this.query = query2;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            int vectorDoc = this.values.docID();
            if (vectorDoc < doc) {
                vectorDoc = this.values.advance(doc);
            }
            return vectorDoc == doc;
        }

        @Override
        public float score() throws IOException {
            assert (this.values.docID() != -1) : this.getClass().getSimpleName() + " is not positioned";
            return this.similarity.compare(this.query, this.values.vectorValue());
        }
    }
}

