/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;

public final class TaskExecutor {
    private static final ThreadLocal<Integer> numberOfRunningTasksInCurrentThread = ThreadLocal.withInitial(() -> 0);
    private final Executor executor;

    public TaskExecutor(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "Executor is null");
    }

    public <T> List<T> invokeAll(Collection<Callable<T>> callables) throws IOException {
        TaskGroup<T> taskGroup = new TaskGroup<T>(callables);
        return taskGroup.invokeAll(this.executor);
    }

    public String toString() {
        return "TaskExecutor(executor=" + this.executor + ")";
    }

    private static final class TaskGroup<T> {
        private final Collection<RunnableFuture<T>> futures;

        TaskGroup(Collection<Callable<T>> callables) {
            ArrayList<RunnableFuture<T>> tasks = new ArrayList<RunnableFuture<T>>(callables.size());
            for (Callable<T> callable : callables) {
                tasks.add(this.createTask(callable));
            }
            this.futures = Collections.unmodifiableCollection(tasks);
        }

        RunnableFuture<T> createTask(Callable<T> callable) {
            final AtomicBoolean startedOrCancelled = new AtomicBoolean(false);
            return new FutureTask<T>(() -> {
                if (startedOrCancelled.compareAndSet(false, true)) {
                    try {
                        Integer counter = numberOfRunningTasksInCurrentThread.get();
                        numberOfRunningTasksInCurrentThread.set(counter + 1);
                        Object v = callable.call();
                        return v;
                    }
                    catch (Throwable t2) {
                        this.cancelAll();
                        throw t2;
                    }
                    finally {
                        Integer counter = numberOfRunningTasksInCurrentThread.get();
                        numberOfRunningTasksInCurrentThread.set(counter - 1);
                    }
                }
                return null;
            }){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    assert (!mayInterruptIfRunning) : "cancelling tasks that are running is not supported";
                    return startedOrCancelled.compareAndSet(false, true);
                }
            };
        }

        List<T> invokeAll(Executor executor) throws IOException {
            boolean runOnCallerThread = numberOfRunningTasksInCurrentThread.get() > 0;
            for (Runnable runnable : this.futures) {
                if (runOnCallerThread) {
                    runnable.run();
                    continue;
                }
                executor.execute(runnable);
            }
            Throwable exc = null;
            ArrayList arrayList = new ArrayList(this.futures.size());
            for (Future future : this.futures) {
                try {
                    arrayList.add(future.get());
                }
                catch (InterruptedException e2) {
                    ThreadInterruptedException newException = new ThreadInterruptedException(e2);
                    if (exc == null) {
                        exc = newException;
                        continue;
                    }
                    exc.addSuppressed(newException);
                }
                catch (ExecutionException e3) {
                    if (exc == null) {
                        exc = e3.getCause();
                        continue;
                    }
                    exc.addSuppressed(e3.getCause());
                }
            }
            assert (this.assertAllFuturesCompleted()) : "Some tasks are still running?";
            if (exc != null) {
                throw IOUtils.rethrowAlways(exc);
            }
            return arrayList;
        }

        private boolean assertAllFuturesCompleted() {
            for (RunnableFuture<T> future : this.futures) {
                if (future.isDone()) continue;
                return false;
            }
            return true;
        }

        private void cancelAll() {
            for (Future future : this.futures) {
                future.cancel(false);
            }
        }
    }
}

