/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.queries.function.valuesource.IntFieldSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;

public class MultiValuedIntFieldSource
extends IntFieldSource {
    protected final SortedNumericSelector.Type selector;

    public MultiValuedIntFieldSource(String field, SortedNumericSelector.Type selector) {
        super(field);
        this.selector = selector;
        Objects.requireNonNull(field, "Field is required to create a MultiValuedIntFieldSource");
        Objects.requireNonNull(selector, "SortedNumericSelector is required to create a MultiValuedIntFieldSource");
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortedNumericSortField(this.field, SortField.Type.INT, reverse, this.selector);
    }

    @Override
    public String description() {
        return "int(" + this.field + "," + this.selector.name() + ")";
    }

    @Override
    protected NumericDocValues getNumericDocValues(Map<Object, Object> context2, LeafReaderContext readerContext) throws IOException {
        SortedNumericDocValues sortedDv = DocValues.getSortedNumeric(readerContext.reader(), this.field);
        return SortedNumericSelector.wrap(sortedDv, this.selector, SortField.Type.INT);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != MultiValuedIntFieldSource.class) {
            return false;
        }
        MultiValuedIntFieldSource other = (MultiValuedIntFieldSource)o;
        if (this.selector != other.selector) {
            return false;
        }
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        int h2 = super.hashCode();
        return h2 += this.selector.hashCode();
    }
}

