/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.tests;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.internal.tests.ConcurrentMergeSchedulerAccess;
import org.apache.lucene.internal.tests.IndexPackageAccess;
import org.apache.lucene.internal.tests.IndexWriterAccess;
import org.apache.lucene.internal.tests.SegmentReaderAccess;

public final class TestSecrets {
    private static IndexPackageAccess indexPackageAccess;
    private static ConcurrentMergeSchedulerAccess cmsAccess;
    private static SegmentReaderAccess segmentReaderAccess;
    private static IndexWriterAccess indexWriterAccess;

    private TestSecrets() {
    }

    public static IndexPackageAccess getIndexPackageAccess() {
        TestSecrets.ensureCaller();
        return Objects.requireNonNull(indexPackageAccess);
    }

    public static ConcurrentMergeSchedulerAccess getConcurrentMergeSchedulerAccess() {
        TestSecrets.ensureCaller();
        return Objects.requireNonNull(cmsAccess);
    }

    public static SegmentReaderAccess getSegmentReaderAccess() {
        TestSecrets.ensureCaller();
        return Objects.requireNonNull(segmentReaderAccess);
    }

    public static IndexWriterAccess getIndexWriterAccess() {
        TestSecrets.ensureCaller();
        return Objects.requireNonNull(indexWriterAccess);
    }

    public static void setIndexWriterAccess(IndexWriterAccess indexWriterAccess) {
        TestSecrets.ensureNull(TestSecrets.indexWriterAccess);
        TestSecrets.indexWriterAccess = indexWriterAccess;
    }

    public static void setIndexPackageAccess(IndexPackageAccess indexPackageAccess) {
        TestSecrets.ensureNull(TestSecrets.indexPackageAccess);
        TestSecrets.indexPackageAccess = indexPackageAccess;
    }

    public static void setConcurrentMergeSchedulerAccess(ConcurrentMergeSchedulerAccess cmsAccess) {
        TestSecrets.ensureNull(TestSecrets.cmsAccess);
        TestSecrets.cmsAccess = cmsAccess;
    }

    public static void setSegmentReaderAccess(SegmentReaderAccess segmentReaderAccess) {
        TestSecrets.ensureNull(TestSecrets.segmentReaderAccess);
        TestSecrets.segmentReaderAccess = segmentReaderAccess;
    }

    private static void ensureNull(Object ob) {
        if (ob != null) {
            throw new AssertionError((Object)"The accessor is already set. It can only be called from inside Lucene Core.");
        }
    }

    private static void ensureCaller() {
        boolean validCaller = StackWalker.getInstance().walk(s2 -> s2.skip(2L).limit(1L).map(StackWalker.StackFrame::getClassName).allMatch(c -> c.startsWith("org.apache.lucene.tests.")));
        if (!validCaller) {
            throw new UnsupportedOperationException("Lucene TestSecrets can only be used by the test-framework.");
        }
    }

    static {
        Consumer<Class> ensureInitialized = clazz -> {
            try {
                Class.forName(clazz.getName());
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        };
        ensureInitialized.accept(ConcurrentMergeScheduler.class);
        ensureInitialized.accept(SegmentReader.class);
        ensureInitialized.accept(IndexWriter.class);
    }
}

