/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.DocumentsWriterStallControl;
import org.apache.lucene.index.FlushPolicy;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.ThreadInterruptedException;

final class DocumentsWriterFlushControl
implements Accountable,
Closeable {
    private final long hardMaxBytesPerDWPT;
    private long activeBytes = 0L;
    private volatile long flushBytes = 0L;
    private volatile int numPending = 0;
    private int numDocsSinceStalled = 0;
    private final AtomicBoolean flushDeletes = new AtomicBoolean(false);
    private boolean fullFlush = false;
    private boolean fullFlushMarkDone = false;
    private final Queue<DocumentsWriterPerThread> flushQueue = new LinkedList<DocumentsWriterPerThread>();
    private final Queue<DocumentsWriterPerThread> blockedFlushes = new LinkedList<DocumentsWriterPerThread>();
    private final List<DocumentsWriterPerThread> flushingWriters = new ArrayList<DocumentsWriterPerThread>();
    private double maxConfiguredRamBuffer = 0.0;
    private long peakActiveBytes = 0L;
    private long peakFlushBytes = 0L;
    private long peakNetBytes = 0L;
    private long peakDelta = 0L;
    private boolean flushByRAMWasDisabled;
    final DocumentsWriterStallControl stallControl = new DocumentsWriterStallControl();
    private final DocumentsWriterPerThreadPool perThreadPool;
    private final FlushPolicy flushPolicy;
    private boolean closed = false;
    private final DocumentsWriter documentsWriter;
    private final LiveIndexWriterConfig config;
    private final InfoStream infoStream;
    private long stallStartNS;

    DocumentsWriterFlushControl(DocumentsWriter documentsWriter, LiveIndexWriterConfig config) {
        this.infoStream = config.getInfoStream();
        this.perThreadPool = documentsWriter.perThreadPool;
        this.flushPolicy = config.getFlushPolicy();
        this.config = config;
        this.hardMaxBytesPerDWPT = (long)config.getRAMPerThreadHardLimitMB() * 1024L * 1024L;
        this.documentsWriter = documentsWriter;
    }

    public synchronized long activeBytes() {
        return this.activeBytes;
    }

    long getFlushingBytes() {
        return this.flushBytes;
    }

    synchronized long netBytes() {
        return this.flushBytes + this.activeBytes;
    }

    private long stallLimitBytes() {
        double maxRamMB = this.config.getRAMBufferSizeMB();
        return maxRamMB != -1.0 ? (long)(2.0 * (maxRamMB * 1024.0 * 1024.0)) : Long.MAX_VALUE;
    }

    private boolean assertMemory() {
        double maxRamMB = this.config.getRAMBufferSizeMB();
        if (maxRamMB != -1.0 && !this.flushByRAMWasDisabled) {
            this.maxConfiguredRamBuffer = Math.max(maxRamMB, this.maxConfiguredRamBuffer);
            long ram = this.flushBytes + this.activeBytes;
            long ramBufferBytes = (long)(this.maxConfiguredRamBuffer * 1024.0 * 1024.0);
            long expected = 2L * ramBufferBytes + (long)(this.numPending + this.numFlushingDWPT() + this.numBlockedFlushes()) * this.peakDelta + (long)this.numDocsSinceStalled * this.peakDelta;
            if (this.peakDelta < ramBufferBytes >> 1) assert (ram <= expected) : "actual mem: " + ram + " byte, expected mem: " + expected + " byte, flush mem: " + this.flushBytes + ", active mem: " + this.activeBytes + ", pending DWPT: " + this.numPending + ", flushing DWPT: " + this.numFlushingDWPT() + ", blocked DWPT: " + this.numBlockedFlushes() + ", peakDelta mem: " + this.peakDelta + " bytes, ramBufferBytes=" + ramBufferBytes + ", maxConfiguredRamBuffer=" + this.maxConfiguredRamBuffer;
        } else {
            this.flushByRAMWasDisabled = true;
        }
        return true;
    }

    private boolean updatePeaks(long delta) {
        this.peakActiveBytes = Math.max(this.peakActiveBytes, this.activeBytes);
        this.peakFlushBytes = Math.max(this.peakFlushBytes, this.flushBytes);
        this.peakNetBytes = Math.max(this.peakNetBytes, this.netBytes());
        this.peakDelta = Math.max(this.peakDelta, delta);
        return true;
    }

    private long ramBufferGranularity() {
        double ramBufferSizeMB = this.config.getRAMBufferSizeMB();
        if (ramBufferSizeMB == -1.0) {
            ramBufferSizeMB = this.config.getRAMPerThreadHardLimitMB();
        }
        long granularity = (long)(ramBufferSizeMB * 1024.0);
        granularity = Math.min(granularity, 16384L);
        return granularity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentsWriterPerThread doAfterDocument(DocumentsWriterPerThread perThread) {
        long delta = perThread.getCommitLastBytesUsedDelta();
        if (this.config.getMaxBufferedDocs() == -1 && delta < this.ramBufferGranularity()) {
            return null;
        }
        DocumentsWriterFlushControl documentsWriterFlushControl = this;
        synchronized (documentsWriterFlushControl) {
            DocumentsWriterPerThread documentsWriterPerThread;
            block13: {
                perThread.commitLastBytesUsed(delta);
                try {
                    if (perThread.isFlushPending()) {
                        this.flushBytes += delta;
                        assert (this.updatePeaks(delta));
                    } else {
                        this.activeBytes += delta;
                        assert (this.updatePeaks(delta));
                        this.flushPolicy.onChange(this, perThread);
                        if (!perThread.isFlushPending() && perThread.ramBytesUsed() > this.hardMaxBytesPerDWPT) {
                            this.setFlushPending(perThread);
                        }
                    }
                    documentsWriterPerThread = this.checkout(perThread, false);
                    boolean stalled = this.updateStallState();
                    if ($assertionsDisabled || this.assertNumDocsSinceStalled(stalled) && this.assertMemory()) break block13;
                }
                catch (Throwable throwable) {
                    boolean stalled = this.updateStallState();
                    assert (this.assertNumDocsSinceStalled(stalled) && this.assertMemory());
                    throw throwable;
                }
                throw new AssertionError();
            }
            return documentsWriterPerThread;
        }
    }

    private DocumentsWriterPerThread checkout(DocumentsWriterPerThread perThread, boolean markPending) {
        assert (Thread.holdsLock(this));
        if (this.fullFlush) {
            if (perThread.isFlushPending()) {
                this.checkoutAndBlock(perThread);
                return this.nextPendingFlush();
            }
        } else {
            if (markPending) {
                assert (!perThread.isFlushPending());
                this.setFlushPending(perThread);
            }
            if (perThread.isFlushPending()) {
                return this.checkOutForFlush(perThread);
            }
        }
        return null;
    }

    private boolean assertNumDocsSinceStalled(boolean stalled) {
        this.numDocsSinceStalled = stalled ? ++this.numDocsSinceStalled : 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doAfterFlush(DocumentsWriterPerThread dwpt) {
        assert (this.flushingWriters.contains(dwpt));
        try {
            this.flushingWriters.remove(dwpt);
            this.flushBytes -= dwpt.getLastCommittedBytesUsed();
            assert (this.assertMemory());
        }
        finally {
            try {
                this.updateStallState();
            }
            finally {
                this.notifyAll();
            }
        }
    }

    private boolean updateStallState() {
        boolean stall;
        assert (Thread.holdsLock(this));
        long limit = this.stallLimitBytes();
        boolean bl = stall = this.activeBytes + this.flushBytes > limit && this.activeBytes < limit && !this.closed;
        if (this.infoStream.isEnabled("DWFC") && stall != this.stallControl.anyStalledThreads()) {
            if (stall) {
                this.infoStream.message("DW", String.format(Locale.ROOT, "now stalling flushes: netBytes: %.1f MB flushBytes: %.1f MB fullFlush: %b", (double)this.netBytes() / 1024.0 / 1024.0, (double)this.getFlushingBytes() / 1024.0 / 1024.0, this.fullFlush));
                this.stallStartNS = System.nanoTime();
            } else {
                this.infoStream.message("DW", String.format(Locale.ROOT, "done stalling flushes for %.1f msec: netBytes: %.1f MB flushBytes: %.1f MB fullFlush: %b", (double)(System.nanoTime() - this.stallStartNS) / (double)TimeUnit.MILLISECONDS.toNanos(1L), (double)this.netBytes() / 1024.0 / 1024.0, (double)this.getFlushingBytes() / 1024.0 / 1024.0, this.fullFlush));
            }
        }
        this.stallControl.updateStalled(stall);
        return stall;
    }

    public synchronized void waitForFlush() {
        while (this.flushingWriters.size() != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e2) {
                throw new ThreadInterruptedException(e2);
            }
        }
    }

    public synchronized void setFlushPending(DocumentsWriterPerThread perThread) {
        assert (!perThread.isFlushPending());
        if (perThread.getNumDocsInRAM() > 0) {
            perThread.setFlushPending();
            long bytes = perThread.getLastCommittedBytesUsed();
            this.flushBytes += bytes;
            this.activeBytes -= bytes;
            ++this.numPending;
            assert (this.assertMemory());
        }
    }

    synchronized void doOnAbort(DocumentsWriterPerThread perThread) {
        try {
            assert (this.perThreadPool.isRegistered(perThread));
            assert (perThread.isHeldByCurrentThread());
            if (perThread.isFlushPending()) {
                this.flushBytes -= perThread.getLastCommittedBytesUsed();
            } else {
                this.activeBytes -= perThread.getLastCommittedBytesUsed();
            }
            assert (this.assertMemory());
        }
        finally {
            this.updateStallState();
            boolean checkedOut = this.perThreadPool.checkout(perThread);
            assert (checkedOut);
        }
    }

    private void checkoutAndBlock(DocumentsWriterPerThread perThread) {
        assert (Thread.holdsLock(this));
        assert (this.perThreadPool.isRegistered(perThread));
        assert (perThread.isHeldByCurrentThread());
        assert (perThread.isFlushPending()) : "can not block non-pending threadstate";
        assert (this.fullFlush) : "can not block if fullFlush == false";
        --this.numPending;
        this.blockedFlushes.add(perThread);
        boolean checkedOut = this.perThreadPool.checkout(perThread);
        assert (checkedOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DocumentsWriterPerThread checkOutForFlush(DocumentsWriterPerThread perThread) {
        assert (Thread.holdsLock(this));
        assert (perThread.isFlushPending());
        assert (perThread.isHeldByCurrentThread());
        assert (this.perThreadPool.isRegistered(perThread));
        try {
            this.addFlushingDWPT(perThread);
            --this.numPending;
            boolean checkedOut = this.perThreadPool.checkout(perThread);
            assert (checkedOut);
            DocumentsWriterPerThread documentsWriterPerThread = perThread;
            return documentsWriterPerThread;
        }
        finally {
            this.updateStallState();
        }
    }

    private void addFlushingDWPT(DocumentsWriterPerThread perThread) {
        assert (!this.flushingWriters.contains(perThread)) : "DWPT is already flushing";
        this.flushingWriters.add(perThread);
    }

    public String toString() {
        return "DocumentsWriterFlushControl [activeBytes=" + this.activeBytes + ", flushBytes=" + this.flushBytes + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentsWriterPerThread nextPendingFlush() {
        int numPending;
        boolean fullFlush;
        DocumentsWriterFlushControl documentsWriterFlushControl = this;
        synchronized (documentsWriterFlushControl) {
            DocumentsWriterPerThread poll = this.flushQueue.poll();
            if (poll != null) {
                this.updateStallState();
                return poll;
            }
            fullFlush = this.fullFlush;
            numPending = this.numPending;
        }
        if (numPending > 0 && !fullFlush) {
            for (DocumentsWriterPerThread next : this.perThreadPool) {
                if (!next.isFlushPending() || !next.tryLock()) continue;
                try {
                    if (!this.perThreadPool.isRegistered(next)) continue;
                    DocumentsWriterPerThread documentsWriterPerThread = this.checkOutForFlush(next);
                    return documentsWriterPerThread;
                }
                finally {
                    next.unlock();
                }
            }
        }
        return null;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }

    public Iterator<DocumentsWriterPerThread> allActiveWriters() {
        return this.perThreadPool.iterator();
    }

    synchronized void doOnDelete() {
        this.flushPolicy.onChange(this, null);
    }

    public long getDeleteBytesUsed() {
        return this.documentsWriter.deleteQueue.ramBytesUsed();
    }

    @Override
    public long ramBytesUsed() {
        return this.getDeleteBytesUsed() + this.netBytes();
    }

    synchronized int numFlushingDWPT() {
        return this.flushingWriters.size();
    }

    public boolean getAndResetApplyAllDeletes() {
        return this.flushDeletes.getAndSet(false);
    }

    public boolean getApplyAllDeletes() {
        return this.flushDeletes.get();
    }

    public void setApplyAllDeletes() {
        this.flushDeletes.set(true);
    }

    DocumentsWriterPerThread obtainAndLock() {
        while (!this.closed) {
            DocumentsWriterPerThread perThread = this.perThreadPool.getAndLock();
            if (perThread.deleteQueue == this.documentsWriter.deleteQueue) {
                return perThread;
            }
            try {
                assert (this.fullFlush && !this.fullFlushMarkDone) : "found a stale DWPT but full flush mark phase is already done fullFlush: " + this.fullFlush + " markDone: " + this.fullFlushMarkDone;
            }
            finally {
                perThread.unlock();
            }
        }
        throw new AlreadyClosedException("flush control is closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long markForFullFlush() {
        long seqNo;
        DocumentsWriterDeleteQueue flushingQueue;
        DocumentsWriterFlushControl documentsWriterFlushControl = this;
        synchronized (documentsWriterFlushControl) {
            assert (!this.fullFlush) : "called DWFC#markForFullFlush() while full flush is still running";
            assert (!this.fullFlushMarkDone) : "full flush collection marker is still set to true";
            this.fullFlush = true;
            flushingQueue = this.documentsWriter.deleteQueue;
            this.perThreadPool.lockNewWriters();
            try {
                DocumentsWriterDeleteQueue newQueue = this.documentsWriter.deleteQueue.advanceQueue(this.perThreadPool.size());
                seqNo = this.documentsWriter.deleteQueue.getMaxSeqNo();
                this.documentsWriter.resetDeleteQueue(newQueue);
            }
            finally {
                this.perThreadPool.unlockNewWriters();
            }
        }
        ArrayList<DocumentsWriterPerThread> fullFlushBuffer = new ArrayList<DocumentsWriterPerThread>();
        for (DocumentsWriterPerThread next : this.perThreadPool.filterAndLock(dwpt -> dwpt.deleteQueue == flushingQueue)) {
            try {
                if (next.getNumDocsInRAM() > 0) {
                    DocumentsWriterPerThread flushingDWPT;
                    DocumentsWriterFlushControl documentsWriterFlushControl2 = this;
                    synchronized (documentsWriterFlushControl2) {
                        if (!next.isFlushPending()) {
                            this.setFlushPending(next);
                        }
                        flushingDWPT = this.checkOutForFlush(next);
                    }
                    assert (flushingDWPT != null) : "DWPT must never be null here since we hold the lock and it holds documents";
                    assert (next == flushingDWPT) : "flushControl returned different DWPT";
                    fullFlushBuffer.add(flushingDWPT);
                    continue;
                }
                boolean checkout = this.perThreadPool.checkout(next);
                assert (checkout);
            }
            finally {
                next.unlock();
            }
        }
        DocumentsWriterFlushControl documentsWriterFlushControl3 = this;
        synchronized (documentsWriterFlushControl3) {
            this.pruneBlockedQueue(flushingQueue);
            assert (this.assertBlockedFlushes(this.documentsWriter.deleteQueue));
            this.flushQueue.addAll(fullFlushBuffer);
            this.updateStallState();
            this.fullFlushMarkDone = true;
        }
        assert (this.assertActiveDeleteQueue(this.documentsWriter.deleteQueue));
        assert (flushingQueue.getLastSequenceNumber() <= flushingQueue.getMaxSeqNo());
        return seqNo;
    }

    private boolean assertActiveDeleteQueue(DocumentsWriterDeleteQueue queue) {
        for (DocumentsWriterPerThread next : this.perThreadPool) {
            assert (next.deleteQueue == queue) : "numDocs: " + next.getNumDocsInRAM();
        }
        return true;
    }

    private void pruneBlockedQueue(DocumentsWriterDeleteQueue flushingQueue) {
        assert (Thread.holdsLock(this));
        Iterator iterator = this.blockedFlushes.iterator();
        while (iterator.hasNext()) {
            DocumentsWriterPerThread blockedFlush = (DocumentsWriterPerThread)iterator.next();
            if (blockedFlush.deleteQueue != flushingQueue) continue;
            iterator.remove();
            this.addFlushingDWPT(blockedFlush);
            this.flushQueue.add(blockedFlush);
        }
    }

    synchronized void finishFullFlush() {
        assert (this.fullFlush);
        assert (this.flushQueue.isEmpty());
        assert (this.flushingWriters.isEmpty());
        try {
            if (!this.blockedFlushes.isEmpty()) {
                assert (this.assertBlockedFlushes(this.documentsWriter.deleteQueue));
                this.pruneBlockedQueue(this.documentsWriter.deleteQueue);
                assert (this.blockedFlushes.isEmpty());
            }
        }
        finally {
            this.fullFlush = false;
            this.fullFlushMarkDone = false;
            this.updateStallState();
        }
    }

    boolean assertBlockedFlushes(DocumentsWriterDeleteQueue flushingQueue) {
        for (DocumentsWriterPerThread blockedFlush : this.blockedFlushes) {
            assert (blockedFlush.deleteQueue == flushingQueue);
        }
        return true;
    }

    synchronized void abortFullFlushes() {
        try {
            this.abortPendingFlushes();
        }
        finally {
            this.fullFlush = false;
            this.fullFlushMarkDone = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void abortPendingFlushes() {
        try {
            for (DocumentsWriterPerThread dwpt : this.flushQueue) {
                try {
                    this.documentsWriter.subtractFlushedNumDocs(dwpt.getNumDocsInRAM());
                    dwpt.abort();
                }
                catch (Exception exception) {}
                continue;
                finally {
                    this.doAfterFlush(dwpt);
                }
            }
            for (DocumentsWriterPerThread blockedFlush : this.blockedFlushes) {
                try {
                    this.addFlushingDWPT(blockedFlush);
                    this.documentsWriter.subtractFlushedNumDocs(blockedFlush.getNumDocsInRAM());
                    blockedFlush.abort();
                }
                catch (Exception exception) {}
                continue;
                finally {
                    this.doAfterFlush(blockedFlush);
                }
            }
        }
        finally {
            this.flushQueue.clear();
            this.blockedFlushes.clear();
            this.updateStallState();
        }
    }

    synchronized boolean isFullFlush() {
        return this.fullFlush;
    }

    synchronized int numQueuedFlushes() {
        return this.flushQueue.size();
    }

    synchronized int numBlockedFlushes() {
        return this.blockedFlushes.size();
    }

    void waitIfStalled() {
        this.stallControl.waitIfStalled();
    }

    boolean anyStalledThreads() {
        return this.stallControl.anyStalledThreads();
    }

    public InfoStream getInfoStream() {
        return this.infoStream;
    }

    synchronized DocumentsWriterPerThread findLargestNonPendingWriter() {
        DocumentsWriterPerThread maxRamUsingWriter = null;
        long maxRamSoFar = -1L;
        int count = 0;
        for (DocumentsWriterPerThread next : this.perThreadPool) {
            if (next.isFlushPending() || next.getNumDocsInRAM() <= 0) continue;
            long nextRam = next.getLastCommittedBytesUsed();
            if (this.infoStream.isEnabled("FP")) {
                this.infoStream.message("FP", "thread state has " + nextRam + " bytes; docInRAM=" + next.getNumDocsInRAM());
            }
            ++count;
            if (nextRam <= maxRamSoFar) continue;
            maxRamSoFar = nextRam;
            maxRamUsingWriter = next;
        }
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", count + " in-use non-flushing threads states");
        }
        return maxRamUsingWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final DocumentsWriterPerThread checkoutLargestNonPendingWriter() {
        block11: {
            DocumentsWriterPerThread largestNonPendingWriter = this.findLargestNonPendingWriter();
            if (largestNonPendingWriter != null) {
                largestNonPendingWriter.lock();
                try {
                    if (!this.perThreadPool.isRegistered(largestNonPendingWriter)) break block11;
                    DocumentsWriterFlushControl documentsWriterFlushControl = this;
                    synchronized (documentsWriterFlushControl) {
                        DocumentsWriterPerThread documentsWriterPerThread;
                        try {
                            documentsWriterPerThread = this.checkout(largestNonPendingWriter, !largestNonPendingWriter.isFlushPending());
                            this.updateStallState();
                        }
                        catch (Throwable throwable) {
                            this.updateStallState();
                            throw throwable;
                        }
                        return documentsWriterPerThread;
                    }
                }
                finally {
                    largestNonPendingWriter.unlock();
                }
            }
        }
        return null;
    }

    long getPeakActiveBytes() {
        return this.peakActiveBytes;
    }

    long getPeakNetBytes() {
        return this.peakNetBytes;
    }
}

