/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.core.DatasetGraphTriplesQuads;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNotSupported;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.system.G;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.lib.NodeLib;
import org.apache.jena.tdb1.store.DatasetPrefixesTDB;
import org.apache.jena.tdb1.store.GraphNonTxnTDB;
import org.apache.jena.tdb1.store.GraphTDB;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.QuadTable;
import org.apache.jena.tdb1.store.StorageConfig;
import org.apache.jena.tdb1.store.TripleTable;
import org.apache.jena.tdb1.store.nodetupletable.NodeTupleTable;

public final class DatasetGraphTDB
extends DatasetGraphTriplesQuads
implements Sync,
Closeable {
    private TripleTable tripleTable;
    private QuadTable quadTable;
    private DatasetPrefixesTDB prefixes;
    private final ReorderTransformation transform;
    private final StorageConfig config;
    private boolean closed = false;
    private static final int sliceSize = 1000;
    private final Transactional txn = new TransactionalNotSupported();

    public DatasetGraphTDB(TripleTable tripleTable, QuadTable quadTable, DatasetPrefixesTDB prefixes, ReorderTransformation transform, StorageConfig config) {
        this.tripleTable = tripleTable;
        this.quadTable = quadTable;
        this.prefixes = prefixes;
        this.transform = transform;
        this.config = config;
    }

    public QuadTable getQuadTable() {
        return this.quadTable;
    }

    public TripleTable getTripleTable() {
        return this.tripleTable;
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s2, Node p, Node o) {
        return G.triples2quadsDftGraph(this.getTripleTable().find(s2, p, o));
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g2, Node s2, Node p, Node o) {
        return this.getQuadTable().find(g2, s2, p, o);
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s2, Node p, Node o) {
        return this.getQuadTable().find(Node.ANY, s2, p, o);
    }

    @Override
    protected void addToDftGraph(Node s2, Node p, Node o) {
        this.getTripleTable().add(s2, p, o);
    }

    @Override
    protected void addToNamedGraph(Node g2, Node s2, Node p, Node o) {
        this.getQuadTable().add(g2, s2, p, o);
    }

    @Override
    protected void deleteFromDftGraph(Node s2, Node p, Node o) {
        this.getTripleTable().delete(s2, p, o);
    }

    @Override
    protected void deleteFromNamedGraph(Node g2, Node s2, Node p, Node o) {
        this.getQuadTable().delete(g2, s2, p, o);
    }

    public GraphTDB getDefaultGraphTDB() {
        return (GraphTDB)this.getDefaultGraph();
    }

    public GraphTDB getGraphTDB(Node graphNode) {
        return (GraphTDB)this.getGraph(graphNode);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.tripleTable.close();
        this.quadTable.close();
        this.prefixes.close();
        this.tripleTable = null;
        this.quadTable = null;
        this.prefixes = null;
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        if (Quad.isDefaultGraph(graphNode) || Quad.isUnionGraph(graphNode)) {
            return true;
        }
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().findAsNodeIds(graphNode, null, null, null);
        if (x == null) {
            return false;
        }
        boolean result = x.hasNext();
        return result;
    }

    @Override
    public Graph getDefaultGraph() {
        return new GraphNonTxnTDB(this, null);
    }

    @Override
    public Graph getUnionGraph() {
        return this.getGraph(Quad.unionGraph);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return new GraphNonTxnTDB(this, graphNode);
    }

    @Override
    public void removeGraph(Node graphNode) {
        this.deleteAny(graphNode, Node.ANY, Node.ANY, Node.ANY);
        if (graphNode.isURI()) {
            this.getStoragePrefixes().removeAllFromPrefixMap(graphNode.getURI());
        }
    }

    public StorageConfig getConfig() {
        return this.config;
    }

    public ReorderTransformation getReorderTransform() {
        return this.transform;
    }

    @Override
    public PrefixMap prefixes() {
        return this.getStoragePrefixes().getPrefixMap();
    }

    public DatasetPrefixesTDB getStoragePrefixes() {
        return this.prefixes;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().findAll();
        Iter<NodeId> z = Iter.iter(x).map(t2 -> (NodeId)t2.get(0)).distinct();
        return NodeLib.nodes(this.quadTable.getNodeTupleTable().getNodeTable(), z);
    }

    @Override
    public long size() {
        return Iter.count(this.listGraphNodes());
    }

    @Override
    public boolean isEmpty() {
        return this.getTripleTable().isEmpty() && this.getQuadTable().isEmpty();
    }

    @Override
    public void clear() {
        this.getTripleTable().clearTriples();
        this.getQuadTable().clearQuads();
    }

    public NodeTupleTable chooseNodeTupleTable(Node graphNode) {
        if (graphNode == null || Quad.isDefaultGraph(graphNode)) {
            return this.getTripleTable().getNodeTupleTable();
        }
        return this.getQuadTable().getNodeTupleTable();
    }

    @Override
    public void deleteAny(Node g2, Node s2, Node p, Node o) {
        int len;
        boolean isDftGraph = g2 == null || Quad.isDefaultGraph(g2);
        NodeTupleTable t2 = this.chooseNodeTupleTable(g2);
        Tuple[] array = new Tuple[1000];
        do {
            Iterator<Tuple<NodeId>> iter = null;
            iter = isDftGraph ? t2.findAsNodeIds(s2, p, o) : t2.findAsNodeIds(g2, s2, p, o);
            if (iter == null) {
                return;
            }
            for (len = 0; len < 1000 && iter.hasNext(); ++len) {
                array[len] = iter.next();
            }
            for (int i = 0; i < len; ++i) {
                t2.getTupleTable().delete(array[i]);
                array[i] = null;
            }
        } while (len >= 1000);
    }

    public Location getLocation() {
        return this.config.location;
    }

    @Override
    public void sync() {
        this.tripleTable.sync();
        this.quadTable.sync();
        this.prefixes.sync();
    }

    @Override
    public String toString() {
        return "TDB1: " + this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public void begin() {
        this.txn.begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.txn.begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    @Override
    public boolean promote(Transactional.Promote txnType) {
        return this.txn.promote(txnType);
    }

    @Override
    public void commit() {
        this.txn.commit();
    }

    @Override
    public void abort() {
        this.txn.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    @Override
    public void end() {
        this.txn.end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.txn.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.txn.transactionType();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return false;
    }
}

