/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.util.ArrayList;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.resultset.ResultSetMem;
import org.apache.jena.sparql.vocabulary.ResultSetGraphVocab;
import org.apache.jena.vocabulary.RDF;

public class RDFInput
extends ResultSetMem {
    public RDFInput(Model model) {
        this.buildFromDumpFormat(model);
    }

    private void buildFromDumpFormat(Model resultsModel) {
        this.varNames = new ArrayList();
        StmtIterator sIter = resultsModel.listStatements(null, RDF.type, ResultSetGraphVocab.ResultSet);
        while (sIter.hasNext()) {
            Statement s2 = sIter.nextStatement();
            Resource root2 = s2.getSubject();
            this.buildOneResource(root2);
        }
        sIter.close();
        this.reset();
    }

    private void buildOneResource(Resource root2) {
        this.buildVariables(root2);
        int count = this.buildPreprocess(root2);
        if (root2.getModel().contains(null, ResultSetGraphVocab.index, (RDFNode)null)) {
            this.buildRowsOrdered(root2, count);
        } else {
            this.buildRows(root2);
        }
    }

    private void buildVariables(Resource root2) {
        StmtIterator rVarsIter = root2.listProperties(ResultSetGraphVocab.resultVariable);
        while (rVarsIter.hasNext()) {
            String varName = rVarsIter.nextStatement().getString();
            this.varNames.add(varName);
        }
        rVarsIter.close();
    }

    private int buildPreprocess(Resource root2) {
        StmtIterator solnIter = root2.listProperties(ResultSetGraphVocab.solution);
        int rows = 0;
        int indexed = 0;
        while (solnIter.hasNext()) {
            Resource soln = solnIter.nextStatement().getResource();
            ++rows;
            if (!soln.hasProperty(ResultSetGraphVocab.index)) continue;
            ++indexed;
        }
        solnIter.close();
        if (indexed > 0 && rows != indexed) {
            Log.warn(this, "Rows = " + rows + " but only " + indexed + " indexes");
            return rows;
        }
        return rows;
    }

    private void buildRowsOrdered(Resource root2, int count) {
        Literal ind;
        StmtIterator sIter;
        Model m4 = root2.getModel();
        BindingBuilder builder = Binding.builder();
        int index = 1;
        while ((sIter = m4.listStatements(null, ResultSetGraphVocab.index, ind = m4.createTypedLiteral((Object)index, (RDFDatatype)XSDDatatype.XSDinteger))).hasNext()) {
            Statement s2 = sIter.nextStatement();
            if (sIter.hasNext()) {
                Log.warn(this, "More than one solution: index = " + index);
            }
            Resource soln = s2.getSubject();
            Binding rb = this.buildBinding(builder, soln);
            this.rows.add(rb);
            sIter.close();
            ++index;
        }
        if (this.rows.size() != count) {
            Log.warn(this, "Found " + this.rows.size() + ": expected " + count);
        }
    }

    private void buildRows(Resource root2) {
        int count = 0;
        StmtIterator solnIter = root2.listProperties(ResultSetGraphVocab.solution);
        BindingBuilder builder = Binding.builder();
        while (solnIter.hasNext()) {
            Resource soln = solnIter.nextStatement().getResource();
            ++count;
            Binding rb = this.buildBinding(builder, soln);
            this.rows.add(rb);
        }
        solnIter.close();
        if (root2.hasProperty(ResultSetGraphVocab.size)) {
            try {
                int size = root2.getRequiredProperty(ResultSetGraphVocab.size).getInt();
                if (size != count) {
                    Log.warn(this, "Warning: Declared size = " + size + " : Count = " + count);
                }
            }
            catch (JenaException jenaException) {
                // empty catch block
            }
        }
    }

    private Binding buildBinding(BindingBuilder builder, Resource soln) {
        builder.reset();
        StmtIterator bindingIter = soln.listProperties(ResultSetGraphVocab.binding);
        while (bindingIter.hasNext()) {
            Resource binding = bindingIter.nextStatement().getResource();
            String var = binding.getRequiredProperty(ResultSetGraphVocab.variable).getString();
            try {
                RDFNode val = binding.getRequiredProperty(ResultSetGraphVocab.value).getObject();
                builder.add(Var.alloc(var), val.asNode());
            }
            catch (PropertyNotFoundException ex) {
                Log.warn(this, "Failed to get value for ?" + var);
            }
        }
        bindingIter.close();
        return builder.build();
    }

    public static ResultSet fromRDF(Model model) {
        return new RDFInput(model);
    }
}

