/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify.request;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.modify.request.UpdateVisitor;
import org.apache.jena.sparql.util.NodeIsomorphismMap;
import org.apache.jena.update.Update;

public class UpdateCreate
extends Update {
    protected final Node graphRef;
    protected final boolean silent;

    public UpdateCreate(String s2) {
        this(NodeFactory.createURI(s2), false);
    }

    public UpdateCreate(String s2, boolean silent) {
        this(NodeFactory.createURI(s2), silent);
    }

    public UpdateCreate(Node iri2) {
        this(iri2, false);
    }

    public UpdateCreate(Node iri2, boolean silent) {
        this.graphRef = iri2;
        this.silent = silent;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public Node getGraph() {
        return this.graphRef;
    }

    @Override
    public void visit(UpdateVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equalTo(Update obj, NodeIsomorphismMap isoMap) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateCreate other = (UpdateCreate)obj;
        return this.silent == other.silent && isoMap.makeIsomorphic(this.graphRef, other.graphRef);
    }
}

