/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpTriple
extends Op0 {
    private final Triple triple;
    private OpBGP opBGP = null;

    public OpTriple(Triple triple) {
        this.triple = triple;
    }

    public final Triple getTriple() {
        return this.triple;
    }

    public final OpBGP asBGP() {
        if (this.opBGP == null) {
            BasicPattern bp = new BasicPattern();
            bp.add(this.getTriple());
            this.opBGP = new OpBGP(bp);
        }
        return this.opBGP;
    }

    @Override
    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    @Override
    public Op0 copy() {
        return new OpTriple(this.triple);
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpTriple)) {
            return false;
        }
        OpTriple opTriple = (OpTriple)other;
        return Iso.tripleIso(this.getTriple(), opTriple.getTriple(), labelMap);
    }

    @Override
    public int hashCode() {
        return 0xBA ^ this.triple.hashCode();
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public String getName() {
        return "triple";
    }

    public boolean equivalent(OpBGP opBGP) {
        BasicPattern bgp = opBGP.getPattern();
        if (bgp.size() != 1) {
            return false;
        }
        Triple t2 = bgp.get(0);
        return this.triple.equals(t2);
    }
}

