/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.Cardinality;
import org.apache.jena.shex.expressions.SemAct;
import org.apache.jena.shex.expressions.TripleExprVisitor;
import org.apache.jena.shex.expressions.TripleExpression;

public class TripleExprCardinality
extends TripleExpression {
    private final TripleExpression other;
    private final Cardinality cardinality;
    private final int min;
    private final int max;

    public TripleExprCardinality(TripleExpression tripleExpr, Cardinality cardinality, List<SemAct> semActs) {
        super(semActs);
        this.other = tripleExpr;
        this.cardinality = cardinality;
        this.min = cardinality == null ? 1 : cardinality.min;
        this.max = cardinality == null ? 1 : cardinality.max;
    }

    public TripleExpression target() {
        return this.other;
    }

    public String cardinalityString() {
        if (this.cardinality == null) {
            return "";
        }
        return this.cardinality.image;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    @Override
    public void visit(TripleExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.other);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TripleExprCardinality other = (TripleExprCardinality)obj;
        return Objects.equals(this.other, other.other);
    }

    @Override
    public void print(IndentedWriter iOut, NodeFormatter nFmt) {
        String s2 = this.cardinalityString();
        iOut.println("Cardinality");
        if (!s2.isEmpty()) {
            iOut.println("Cardinality = " + s2);
        }
        iOut.incIndent();
        this.other.print(iOut, nFmt);
        iOut.decIndent();
        iOut.println("/Cardinality");
    }

    @Override
    public String toString() {
        String s2 = this.cardinalityString();
        if (s2.isEmpty()) {
            return "Cardinality [{-} other=" + this.other + "]";
        }
        return "Cardinality [" + s2 + " other=" + this.other + "]";
    }
}

