/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfTriple;
import com.apicatalog.rdf.RdfValue;
import com.apicatalog.rdf.spi.RdfProvider;
import java.util.Optional;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.NodeUtils;

public class JenaTitanium {
    private static long line = -1L;
    private static long col = -1L;

    public static RdfDataset convert(DatasetGraph dataset) {
        RdfProvider provider = RdfProvider.provider();
        RdfDataset rdfDataset = provider.createDataset();
        NodeToLabel labelMapping = NodeToLabel.createScopeByDocument();
        dataset.find().forEachRemaining(quad -> {
            RdfResource subject = JenaTitanium.resource(provider, labelMapping, quad.getSubject());
            RdfResource predicate = JenaTitanium.resource(provider, labelMapping, quad.getPredicate());
            RdfValue object = JenaTitanium.nodeToValue(provider, labelMapping, quad.getObject());
            if (quad.isDefaultGraph()) {
                RdfTriple t2 = provider.createTriple(subject, predicate, object);
                rdfDataset.add(t2);
            } else {
                RdfNQuad q = provider.createNQuad(subject, predicate, object, JenaTitanium.resource(provider, labelMapping, quad.getGraph()));
                rdfDataset.add(q);
            }
        });
        return rdfDataset;
    }

    public static DatasetGraph convert(RdfDataset dataset, ParserProfile parserProfile) {
        DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
        StreamRDF dest = StreamRDFLib.dataset(dsg);
        JenaTitanium.convert(dataset, parserProfile, dest);
        return dsg;
    }

    public static void convert(RdfDataset dataset, StreamRDF output) {
        JenaTitanium.convert(dataset, RiotLib.dftProfile(), output);
    }

    public static void convert(RdfDataset dataset, ParserProfile parserProfile, StreamRDF output) {
        RdfProvider provider = RdfProvider.provider();
        for (RdfNQuad rdfQuad : dataset.toList()) {
            Optional<RdfResource> gn = rdfQuad.getGraphName();
            RdfResource subj = rdfQuad.getSubject();
            RdfResource pred = rdfQuad.getPredicate();
            RdfValue obj = rdfQuad.getObject();
            Node g2 = JenaTitanium.valueToNode(parserProfile, gn);
            Node s2 = JenaTitanium.valueToNode(parserProfile, subj);
            Node p = JenaTitanium.valueToNode(parserProfile, pred);
            Node o = JenaTitanium.valueToNode(parserProfile, obj);
            if (g2 == null) {
                output.triple(Triple.create(s2, p, o));
                continue;
            }
            output.quad(Quad.create(g2, s2, p, o));
        }
    }

    private static Node valueToNode(ParserProfile parserProfile, Optional<RdfResource> value) {
        if (value.isEmpty()) {
            return null;
        }
        return JenaTitanium.valueToNode(parserProfile, value.get());
    }

    private static Node valueToNode(ParserProfile parserProfile, RdfValue value) {
        if (value.isBlankNode()) {
            return parserProfile.createBlankNode(null, value.getValue(), line, col);
        }
        if (value.isIRI()) {
            return parserProfile.createURI(value.getValue(), line, col);
        }
        if (value.isLiteral()) {
            RdfLiteral literal = (RdfLiteral)value;
            String lex = literal.getValue();
            String dt = literal.getDatatype();
            RDFDatatype datatype = NodeFactory.getType(dt);
            Optional<String> lang = literal.getLanguage();
            if (lang.isPresent()) {
                return parserProfile.createLangLiteral(lex, lang.get(), line, col);
            }
            return parserProfile.createTypedLiteral(lex, datatype, line, col);
        }
        throw new JenaTitaniumException("Not recognized: " + value);
    }

    private static RdfResource resource(RdfProvider provider, NodeToLabel labelMapping, Node node) {
        if (node.isBlank()) {
            String s2 = (String)labelMapping.get(null, node);
            return provider.createBlankNode(s2);
        }
        if (node.isURI()) {
            return provider.createIRI(node.getURI());
        }
        throw new JenaTitaniumException("Can not convert to an RdfResource : " + node);
    }

    private static RdfValue nodeToValue(RdfProvider provider, NodeToLabel labelMapping, Node node) {
        if (node.isBlank() || node.isURI()) {
            return JenaTitanium.resource(provider, labelMapping, node);
        }
        if (node.isLiteral()) {
            String lex = node.getLiteralLexicalForm();
            if (NodeUtils.hasLang(node)) {
                return provider.createLangString(lex, node.getLiteralLanguage());
            }
            return provider.createTypedString(lex, node.getLiteralDatatypeURI());
        }
        throw new JenaTitaniumException("Can not be converted: " + node);
    }

    public static class JenaTitaniumException
    extends JenaException {
        public JenaTitaniumException(String msg) {
            super(msg);
        }
    }
}

