/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.engine.MapperX;
import org.apache.jena.sparql.core.Quad;

public class Mappers {
    private static MapperX<Node, Triple> mapperSingletonTriple = new MapperTriple();
    private static MapperX<Node, Tuple<Node>> mapperSingletonTuple = new MapperTuple();

    public static MapperX<Node, Triple> mapperTriple() {
        return mapperSingletonTriple;
    }

    public static MapperX<Node, Quad> mapperQuad(Node g2) {
        return new MapperQuad(g2);
    }

    private static class MapperQuad
    implements MapperX<Node, Quad> {
        private final Node graph;

        private MapperQuad(Node g2) {
            this.graph = g2;
        }

        @Override
        public Node fromNode(Node n) {
            return n;
        }

        @Override
        public Node toNode(Node x) {
            return x;
        }

        @Override
        public Node subject(Quad quad) {
            return quad.getSubject();
        }

        @Override
        public Node predicate(Quad quad) {
            return quad.getPredicate();
        }

        @Override
        public Node object(Quad quad) {
            return quad.getObject();
        }
    }

    private static class MapperTriple
    implements MapperX<Node, Triple> {
        private MapperTriple() {
        }

        @Override
        public Node fromNode(Node n) {
            return n;
        }

        @Override
        public Node toNode(Node x) {
            return x;
        }

        @Override
        public Node subject(Triple triple) {
            return triple.getSubject();
        }

        @Override
        public Node predicate(Triple triple) {
            return triple.getPredicate();
        }

        @Override
        public Node object(Triple triple) {
            return triple.getObject();
        }
    }

    private static class MapperTuple
    implements MapperX<Node, Tuple<Node>> {
        private MapperTuple() {
        }

        @Override
        public Node fromNode(Node n) {
            return n;
        }

        @Override
        public Node toNode(Node x) {
            return x;
        }

        @Override
        public Node subject(Tuple<Node> tuple) {
            return MapperTuple.offset(tuple, 0);
        }

        @Override
        public Node predicate(Tuple<Node> tuple) {
            return MapperTuple.offset(tuple, 1);
        }

        @Override
        public Node object(Tuple<Node> tuple) {
            return MapperTuple.offset(tuple, 2);
        }

        private static Node offset(Tuple<Node> tuple, int i) {
            int idx = tuple.len() == 3 ? i : i + 1;
            return tuple.get(idx);
        }
    }
}

