/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog.rotate;

import java.nio.file.Path;
import java.util.Objects;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.rdfpatch.filelog.rotate.FileMgr;

public class Filename {
    public final Path directory;
    public final String basename;
    public final String separator;
    public final String modifier;
    public final String compression;
    private Path absolute;
    private static String SEP = ".";

    public Filename(Path directory, String basename, String separator, String modifier, String compression) {
        Objects.requireNonNull(directory, "directory");
        Objects.requireNonNull(basename, "basename");
        this.directory = directory;
        this.basename = basename;
        if (1 == Filename.countNonNulls(separator, modifier)) {
            FmtLog.warn(FileMgr.LOG, "Both separator and modifier must be set, or both be null: (s=%s, m=%s)", separator, modifier);
            separator = null;
            modifier = null;
        }
        this.separator = separator;
        this.modifier = modifier;
        if (compression != null && compression.startsWith(SEP)) {
            compression.substring(SEP.length());
        }
        this.compression = compression;
        this.absolute = null;
    }

    private Path toAbsolutePath() {
        String fn = this.asFilenameString();
        return this.directory.resolve(fn).toAbsolutePath();
    }

    public boolean isBasename() {
        return this.modifier == null || this.separator == null;
    }

    public boolean isCompressed() {
        return this.compression != null;
    }

    public String asFilenameString() {
        Object fn = this.basename;
        if (!this.isBasename()) {
            fn = (String)fn + this.separator + this.modifier;
        }
        if (this.isCompressed()) {
            fn = (String)fn + SEP + this.compression;
        }
        return fn;
    }

    public Path absolute() {
        if (this.absolute == null) {
            this.absolute = this.toAbsolutePath();
        }
        return this.absolute;
    }

    public String toString() {
        Object fn = this.basename;
        String MARK = "";
        if (!this.isBasename()) {
            fn = (String)fn + MARK + this.separator + MARK + this.modifier;
        }
        if (this.isCompressed()) {
            fn = (String)fn + MARK + this.compression;
        }
        return fn;
    }

    private static int countNonNulls(Object ... objects) {
        int x = 0;
        for (Object obj : objects) {
            if (obj == null) continue;
            ++x;
        }
        return x;
    }
}

