/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.changes;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.changes.RDFChangesCounter;
import org.apache.jena.rdfpatch.system.Printer;

public class RDFChangesLogSummary
extends RDFChangesCounter {
    private final Printer printer;
    private Node node = null;
    private static int AbbrevUuidLen = "uuid:".length() + 6;

    public RDFChangesLogSummary(Printer printer) {
        this.printer = printer;
    }

    @Override
    public void header(String field, Node value) {
        if (Objects.equals(field, "id")) {
            this.node = value;
        }
        super.header(field, value);
    }

    @Override
    public void finish() {
        if (this.summary.getDepth() != 0L) {
            return;
        }
        String s2 = "unset";
        if (this.node != null) {
            s2 = this.node.isURI() ? this.node.getURI() : (this.node.isBlank() ? this.node.getBlankNodeLabel() : this.node.getLiteralLexicalForm());
        }
        if (s2.startsWith("uuid:") && s2.length() > AbbrevUuidLen) {
            s2 = s2.substring(0, 11);
        }
        this.printer.print("%s :: Add %d :: Del %d :: P-Add %d :: P-Del %d", s2, this.summary.countAddData, this.summary.countDeleteData, this.summary.countAddPrefix, this.summary.countDeletePrefix);
        super.reset();
    }
}

