/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.shared.CannotEncodeCharacterException;
import org.apache.jena.util.XMLChar;

public class Util {
    protected static Pattern standardEntities = Pattern.compile("&|<|>|\t|\n|\r|'|\"");
    protected static Pattern entityValueEntities = Pattern.compile("&|%|'|\"");
    protected static Pattern elementContentEntities = Pattern.compile("<|>|&|[\u0000-\u001f&&[^\n\t]]|\uffff|\ufffe");

    public static int splitNamespaceXML(String uri) {
        char ch;
        int i;
        int lg = uri.length();
        if (lg == 0) {
            return 0;
        }
        for (i = lg - 1; i >= 1 && !Util.notNameChar(ch = uri.charAt(i)); --i) {
        }
        int j = i + 1;
        if (j >= lg) {
            return lg;
        }
        if (j >= 2 && uri.charAt(j - 2) == '%') {
            ++j;
        }
        if (j >= 1 && uri.charAt(j - 1) == '%' && (j += 2) > lg) {
            return lg;
        }
        while (j < lg && (!XMLChar.isNCNameStart(ch = uri.charAt(j)) || j == 7 && uri.startsWith("mailto:"))) {
            ++j;
        }
        return j;
    }

    public static boolean notNameChar(char ch) {
        return !XMLChar.isNCName(ch);
    }

    public static String substituteStandardEntities(String s2) {
        if (standardEntities.matcher(s2).find()) {
            return Util.substituteEntitiesInElementContent(s2).replaceAll("'", "&apos;").replaceAll("\t", "&#9;").replaceAll("\n", "&#xA;").replaceAll("\r", "&#xD;").replaceAll("\"", "&quot;");
        }
        return s2;
    }

    public static String substituteEntitiesInEntityValue(String s2) {
        if (entityValueEntities.matcher(s2).find()) {
            return s2.replaceAll("&", "&amp;").replaceAll("'", "&apos;").replaceAll("%", "&#37;").replaceAll("\"", "&quot;");
        }
        return s2;
    }

    public static String substituteEntitiesInElementContent(String s2) {
        Matcher m4 = elementContentEntities.matcher(s2);
        if (!m4.find()) {
            return s2;
        }
        int start = 0;
        StringBuilder result = new StringBuilder();
        do {
            result.append(s2.substring(start, m4.start()));
            char ch = s2.charAt(m4.start());
            switch (ch) {
                case '\r': {
                    result.append("&#xD;");
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                default: {
                    throw new CannotEncodeCharacterException(ch, "XML");
                }
            }
        } while (m4.find(start = m4.end()));
        result.append(s2.substring(start));
        return result.toString();
    }

    public static String replace(String s2, String oldString, String newString) {
        return s2.replace(oldString, newString);
    }

    public static boolean isSimpleString(Node n) {
        Objects.requireNonNull(n);
        if (!n.isLiteral()) {
            return false;
        }
        RDFDatatype dt = n.getLiteralDatatype();
        if (dt == null) {
            return !Util.hasLangTest(n);
        }
        return dt.equals(XSDDatatype.XSDstring);
    }

    public static boolean isLangString(Node n) {
        Objects.requireNonNull(n);
        if (!n.isLiteral()) {
            return false;
        }
        return Util.hasLangTest(n) && !Util.hasDirectionText(n);
    }

    public static boolean isDirLangString(Node n) {
        Objects.requireNonNull(n);
        if (!n.isLiteral()) {
            return false;
        }
        return Util.hasDirectionText(n) && Util.hasLangTest(n);
    }

    public static boolean hasLang(Node n) {
        if (!n.isLiteral()) {
            return false;
        }
        String lang = n.getLiteralLanguage();
        return Util.hasLangTest(n);
    }

    public static boolean hasDirection(Node n) {
        if (!n.isLiteral()) {
            return false;
        }
        return Util.hasDirectionText(n);
    }

    private static boolean hasDirectionText(Node n) {
        TextDirection textDir = n.getLiteralTextDirection();
        return textDir != null;
    }

    private static boolean hasLangTest(Node n) {
        String lang = n.getLiteralLanguage();
        return !Lib.isEmpty(lang);
    }

    public static boolean isSimpleString(Literal lit) {
        Objects.requireNonNull(lit);
        RDFDatatype dt = lit.getDatatype();
        if (dt == null) {
            return !Util.isLangString(lit);
        }
        return dt.equals(XSDDatatype.XSDstring);
    }

    public static boolean isLangString(Literal lit) {
        Objects.requireNonNull(lit);
        String lang = lit.getLanguage();
        if (lang == null) {
            return false;
        }
        return !lang.equals("");
    }

    public static boolean isDirLangString(Literal lit) {
        Objects.requireNonNull(lit);
        String lang = lit.getLanguage();
        if (lang == null) {
            return false;
        }
        String textDir = lit.getTextDirection();
        return textDir != null;
    }
}

