/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.langtag;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;

public class LangTags {
    public static String formatLangtag(String input) {
        if (input == null) {
            return "";
        }
        if (input.isEmpty()) {
            return input;
        }
        return LangTags.basicFormat(input);
    }

    public static String basicFormat(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return string;
        }
        List<String> strings = LangTags.splitOnDash(string);
        if (strings == null) {
            return Lib.lowercase(string);
        }
        StringBuilder sb = new StringBuilder(string.length());
        boolean singleton = false;
        boolean first = true;
        for (String s2 : strings) {
            if (first) {
                sb.append(Lib.lowercase(s2));
                first = false;
                continue;
            }
            first = false;
            sb.append('-');
            if (singleton) {
                sb.append(Lib.lowercase(s2));
                continue;
            }
            sb.append(LangTags.strcase(s2));
            if (s2.length() != 1) continue;
            singleton = true;
        }
        return sb.toString();
    }

    private static List<String> splitOnDash(String x) {
        ArrayList<String> strings = new ArrayList<String>(6);
        StringBuilder sb = new StringBuilder();
        boolean start = true;
        for (int idx = 0; idx < x.length(); ++idx) {
            char ch = x.charAt(idx);
            if (LangTags.isA2ZN(ch)) {
                sb.append(ch);
                continue;
            }
            if (ch == '-') {
                String str2 = sb.toString();
                strings.add(str2);
                sb.setLength(0);
                continue;
            }
            LangTags.error("Bad character: (0x%02X) '%c' index %d", ch, LangTags.str(ch), idx);
        }
        String strLast = sb.toString();
        if (strLast.isEmpty()) {
            return null;
        }
        strings.add(strLast);
        return strings;
    }

    private static void error(String msg, Object ... args) {
        String x = String.format(msg, args);
        Log.warn("LangTag", x);
    }

    private static String strcase(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return Lib.uppercase(string);
        }
        if (string.length() == 4) {
            return LangTags.titlecase(string);
        }
        return Lib.lowercase(string);
    }

    private static String titlecase(String string) {
        if (string == null) {
            return null;
        }
        char ch1 = string.charAt(0);
        ch1 = Character.toUpperCase(ch1);
        string = Lib.lowercase(string.substring(1));
        return ch1 + string;
    }

    private static String str(char ch) {
        return String.format("'%s' U+%04X", Character.valueOf(ch), (int)ch);
    }

    static boolean isA2Z(int ch) {
        return LangTags.range(ch, 'a', 'z') || LangTags.range(ch, 'A', 'Z');
    }

    static boolean isA2ZN(int ch) {
        return LangTags.range(ch, 'a', 'z') || LangTags.range(ch, 'A', 'Z') || LangTags.range(ch, '0', '9');
    }

    private static boolean range(int ch, char a, char b) {
        return ch >= a && ch <= b;
    }
}

