/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;

public abstract class GraphListenerBase
implements GraphListener {
    @Override
    public void notifyAddTriple(Graph g2, Triple t2) {
        this.addEvent(t2);
    }

    @Override
    public void notifyAddArray(Graph g2, Triple[] triples) {
        for (Triple triple : triples) {
            this.addEvent(triple);
        }
    }

    @Override
    public void notifyAddList(Graph g2, List<Triple> triples) {
        this.notifyAddIterator(g2, triples.iterator());
    }

    @Override
    public void notifyAddIterator(Graph g2, Iterator<Triple> it) {
        while (it.hasNext()) {
            this.addEvent(it.next());
        }
    }

    @Override
    public void notifyAddGraph(Graph g2, Graph added) {
        added.find().forEach(this::addEvent);
    }

    @Override
    public void notifyDeleteTriple(Graph g2, Triple t2) {
        this.deleteEvent(t2);
    }

    @Override
    public void notifyDeleteList(Graph g2, List<Triple> triples) {
        this.notifyDeleteIterator(g2, triples.iterator());
    }

    @Override
    public void notifyDeleteArray(Graph g2, Triple[] triples) {
        for (Triple triple : triples) {
            this.deleteEvent(triple);
        }
    }

    @Override
    public void notifyDeleteIterator(Graph g2, Iterator<Triple> it) {
        while (it.hasNext()) {
            this.deleteEvent(it.next());
        }
    }

    @Override
    public void notifyDeleteGraph(Graph g2, Graph removed) {
        removed.find().forEach(this::deleteEvent);
    }

    protected abstract void addEvent(Triple var1);

    protected abstract void deleteEvent(Triple var1);

    @Override
    public void notifyEvent(Graph source, Object value) {
        if (value.equals(GraphEvents.startRead)) {
            this.startRead();
        } else if (value.equals(GraphEvents.finishRead)) {
            this.finishRead();
        }
    }

    protected void startRead() {
    }

    protected void finishRead() {
    }
}

