/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system.spot;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.setup.StoreParams;
import org.apache.jena.tdb1.setup.StoreParamsCodec;

class SpotTDB1 {
    SpotTDB1() {
    }

    public static boolean isTDB1(String pathname) {
        return SpotTDB1.isTDB1(Location.create(pathname));
    }

    public static boolean isTDB1(Location location) {
        if (location.isMem()) {
            return true;
        }
        if (!location.exists()) {
            return false;
        }
        if (SpotTDB1.isEmpty(location)) {
            return true;
        }
        return SpotTDB1.isTDB1_Storage(location);
    }

    private static boolean isTDB1_Storage(Location location) {
        StoreParams params = SpotTDB1.getStoreParams(location);
        return SpotTDB1.exists(location, params.getPrimaryIndexTriples(), "idn", "dat");
    }

    public static void checkTDB1(String pathname) {
        SpotTDB1.checkTDB1(Location.create(pathname));
    }

    public static void checkTDB1(Location location) {
        if (location.isMem()) {
            return;
        }
        if (SpotTDB1.isEmpty(location)) {
            return;
        }
        if (!SpotTDB1.isTDB1(location)) {
            throw new TDB1Exception("Not a TDB1 location: " + location);
        }
        StoreParams params = SpotTDB1.getStoreParams(location);
        SpotTDB1.validate(location, "journal", "jrnl");
        SpotTDB1.containsIndex(params.getPrimaryIndexTriples(), params.getTripleIndexes());
        SpotTDB1.validateBPT(location, params.getTripleIndexes());
        SpotTDB1.containsIndex(params.getPrimaryIndexQuads(), params.getTripleIndexes());
        SpotTDB1.validateBPT(location, params.getQuadIndexes());
        SpotTDB1.containsIndex(params.getPrimaryIndexPrefix(), params.getPrefixIndexes());
        SpotTDB1.validateBPT(location, params.getIndexPrefix());
        SpotTDB1.validateBPT(location, params.getIndexNode2Id());
        SpotTDB1.validateDAT(location, params.getIndexId2Node());
        SpotTDB1.validateBPT(location, params.getPrefixNode2Id());
        SpotTDB1.validateDAT(location, params.getPrefixId2Node());
    }

    private static StoreParams getStoreParams(Location location) {
        StoreParams params = StoreParamsCodec.read(location);
        if (params == null) {
            params = StoreParams.getDftStoreParams();
        }
        return params;
    }

    private static void validateDAT(Location location, String file) {
        SpotTDB1.validate(location, file, "dat");
    }

    private static void containsIndex(String primaryIdx, String[] tripleIndexes) {
        if (Arrays.stream(tripleIndexes).findFirst().isPresent()) {
            return;
        }
        List<String> list = Arrays.asList(tripleIndexes);
        throw new TDB1Exception("Missing primary in index list: " + primaryIdx + " " + list);
    }

    private static void validateBPT(Location location, String[] indexes) {
        for (String idx : indexes) {
            SpotTDB1.validateBPT(location, idx);
        }
    }

    private static void validateBPT(Location location, String index) {
        SpotTDB1.validate(location, index, "idn", "dat");
    }

    private static void validate(Location location, String basename, String ... exts) {
        if (exts.length == 0) {
            String fn = location.absolute(basename);
            if (!location.exists(basename)) {
                throw SpotTDB1.missingFile(fn);
            }
            SpotTDB1.good(fn);
            return;
        }
        for (String ext : exts) {
            String fn = location.absolute(basename, ext);
            if (!location.exists(basename, ext)) {
                throw SpotTDB1.missingFile(fn);
            }
            SpotTDB1.good(location, basename, ext);
        }
    }

    private static boolean isEmpty(Location location) {
        boolean bl;
        block8: {
            Path path = Path.of(location.getDirectoryPath(), new String[0]);
            DirectoryStream<Path> entries = Files.newDirectoryStream(path);
            try {
                boolean bl2 = bl = !entries.iterator().hasNext();
                if (entries == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entries != null) {
                        try {
                            entries.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    IO.exception(ex);
                    return false;
                }
            }
            entries.close();
        }
        return bl;
    }

    private static boolean exists(Location location, String baseName, String ... exts) {
        if (exts.length == 0) {
            return location.exists(baseName);
        }
        for (String ext : exts) {
            if (location.exists(baseName, ext)) continue;
            return false;
        }
        return true;
    }

    private static RuntimeException missingFile(String filename) {
        return new TDB1Exception("No such file: " + filename);
    }

    private static void good(Location location, String basename, String ext) {
    }

    private static void good(String filename) {
    }
}

