/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.system.ConNeg;
import org.apache.jena.fuseki.system.UploadDetails;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.web.HttpSC;

public class ServletOps {
    private static MediaType mtTextHTML = MediaType.create("text/html");
    private static AcceptList successReponseAccept = AcceptList.create("text/html", "text/plain", "application/json");

    public static void responseSendError(HttpServletResponse response, int statusCode, String message) {
        response.setStatus(statusCode);
        if (message != null) {
            ServletOps.writeMessagePlainTextError(response, message);
        }
    }

    public static void responseSendError(HttpServletResponse response, int statusCode) {
        response.setStatus(statusCode);
    }

    static void writeMessagePlainText(HttpServletResponse response, String message) {
        ServletOps.setNoCache(response);
        if (message == null) {
            return;
        }
        if (!((String)message).endsWith("\n")) {
            message = (String)message + "\n";
        }
        response.setContentLength(((String)message).length());
        response.setContentType("text/plain");
        response.setCharacterEncoding("utf-8");
        try (ServletOutputStream out = response.getOutputStream();){
            out.print((String)message);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void writeMessagePlainTextError(HttpServletResponse response, String message) {
        try {
            ServletOps.writeMessagePlainText(response, message);
        }
        catch (RuntimeIOException runtimeIOException) {
            // empty catch block
        }
    }

    public static void successNoContent(HttpAction action) {
        ServletOps.success(action, 204);
    }

    public static void success(HttpAction action) {
        ServletOps.success(action, 200);
    }

    public static void successCreated(HttpAction action) {
        ServletOps.success(action, 201);
    }

    public static void successNotFound(HttpAction action) {
        ServletOps.success(action, 404);
    }

    public static void success(HttpAction action, int httpStatusCode) {
        action.setResponseStatus(httpStatusCode);
    }

    public static void successPage(HttpAction action, String message) {
        String x = action.getRequestHeader("Accept");
        MediaType mt = null;
        if (x != null && x.equals("*/*") && action.getRequestContentType().equals("application/x-www-form-urlencoded")) {
            mt = mtTextHTML;
        }
        if (mt == null && x != null) {
            mt = ConNeg.chooseContentType(action.getRequest(), successReponseAccept, MediaType.create("text/plain"));
        }
        if (mt == null) {
            mt = mtTextHTML;
        }
        if (WebContent.ctTextPlain.agreesWith(mt)) {
            ServletOps.successPageText(action, message);
            return;
        }
        if (WebContent.ctJSON.agreesWith(mt)) {
            ServletOps.successPageJson(action, message);
            return;
        }
        ServletOps.successPageHtml(action, message);
    }

    private static void successPageJson(HttpAction action, String message) {
        try {
            action.setResponseContentType("application/json");
            action.setResponseCharacterEncoding("utf-8");
            action.setResponseStatus(200);
            ServletOutputStream out = action.getResponseOutputStream();
            JsonObject obj = JsonBuilder.buildObject(builder -> {
                builder.pair("statusCode", 200L);
                if (message != null) {
                    builder.pair("message", message);
                }
            });
            JSON.write(out, (JsonValue)obj);
            return;
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
            return;
        }
    }

    private static void successPageText(HttpAction action, String message) {
        if (message == null) {
            message = HttpSC.getMessage(200);
        }
        try {
            action.setResponseContentType("text/plain");
            action.setResponseCharacterEncoding("utf-8");
            action.setResponseStatus(200);
            PrintWriter out = action.getResponseWriter();
            if (message != null) {
                out.println(message);
            }
            return;
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
            return;
        }
    }

    private static void successPageHtml(HttpAction action, String message) {
        try {
            action.setResponseContentType("text/html");
            action.setResponseCharacterEncoding("utf-8");
            action.setResponseStatus(200);
            PrintWriter out = action.getResponseWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Success</h1>");
            if (message != null) {
                out.println("<p>");
                out.println(message);
                out.println("</p>");
            }
            out.println("</body>");
            out.println("</html>");
            out.flush();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    public static void warning(HttpAction action, String string) {
        action.log.warn(string);
    }

    public static void warning(HttpAction action, String string, Throwable thorwable) {
        action.log.warn(string, thorwable);
    }

    public static void errorParseError(RiotParseException ex) {
        ServletOps.error(400, "Parse Error: " + ex.getMessage());
    }

    public static void errorBadRequest(String string) {
        ServletOps.error(400, string);
    }

    public static void errorNotFound() {
        ServletOps.errorNotFound(HttpSC.Code.NOT_FOUND.getMessage());
    }

    public static void errorNotFound(String string) {
        ServletOps.error(404, string);
    }

    public static void errorNotImplemented(String msg) {
        ServletOps.error(501, msg);
    }

    public static void errorMethodNotAllowed(String method) {
        ServletOps.errorMethodNotAllowed(method, "HTTP method not allowed: " + method);
    }

    public static void errorMethodNotAllowed(String method, String msg) {
        ServletOps.error(405, msg);
    }

    public static void errorForbidden() {
        ServletOps.error(403, "Forbidden");
    }

    public static void errorForbidden(String msg) {
        if (msg != null) {
            ServletOps.error(403, msg);
        } else {
            ServletOps.errorForbidden();
        }
    }

    public static void error(int statusCode) {
        throw new ActionErrorException(statusCode, null, null);
    }

    public static void error(int statusCode, String string) {
        throw new ActionErrorException(statusCode, string, null);
    }

    public static void errorOccurred(String message) {
        ServletOps.errorOccurred(message, null);
    }

    public static void errorOccurred(Throwable ex) {
        ServletOps.errorOccurred(null, ex);
    }

    public static void errorOccurred(String message, Throwable ex) {
        if (message == null) {
            System.err.println();
        }
        if (ex instanceof ActionErrorException) {
            ActionErrorException actionErr = (ActionErrorException)ex;
            throw actionErr;
        }
        throw new ActionErrorException(500, message, ex);
    }

    public static String formatForLog(String string) {
        if (string == null) {
            return "<null>";
        }
        string = string.replace('\n', ' ');
        string = string.replace('\r', ' ');
        return string;
    }

    public static void setNoCache(HttpAction action) {
        ServletOps.setNoCache(action.getResponse());
    }

    public static void setNoCache(HttpServletResponse response) {
        try {
            response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            response.setHeader("Pragma", "no-cache");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void uploadResponse(HttpAction action, UploadDetails details) {
        if (details.getExistedBefore().equals((Object)UploadDetails.PreState.ABSENT)) {
            ServletOps.successCreated(action);
        } else {
            ServletOps.success(action);
        }
        JsonValue v = details.detailsJson();
        ServletOps.sendJson(action, v);
    }

    public static void sendJsonReponse(HttpAction action, JsonValue v) {
        if (v == null) {
            ServletOps.success(action);
            return;
        }
        ServletOps.success(action);
        ServletOps.sendJson(action, v);
    }

    public static void sendJson(HttpAction action, JsonValue jValue) {
        if (jValue == null) {
            return;
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        JSON.write(bytesOut, jValue);
        byte[] bytes = bytesOut.toByteArray();
        try {
            ServletOutputStream out = action.getResponseOutputStream();
            action.setResponseContentType("application/json");
            action.setResponseContentLength(bytes.length);
            action.setResponseCharacterEncoding("utf-8");
            out.write(bytes);
            out.flush();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }
}

