/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.patch;

import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionExecLib;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionREST;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.rdfpatch.PatchException;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.changes.PatchSummary;
import org.apache.jena.rdfpatch.changes.PatchTxnAbortException;
import org.apache.jena.rdfpatch.changes.RDFChangesApply;
import org.apache.jena.rdfpatch.changes.RDFChangesCounter;
import org.apache.jena.rdfpatch.changes.RDFChangesExternalTxn;
import org.apache.jena.rdfpatch.changes.RDFChangesN;
import org.apache.jena.rdfpatch.text.RDFPatchReaderText;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.sparql.core.DatasetGraph;

public class PatchApplyService
extends ActionREST {
    static CounterName counterPatches = CounterName.register("RDFpatch-apply", "rdf-patch.apply.requests");
    static CounterName counterPatchesGood = CounterName.register("RDFpatch-apply", "rdf-patch.apply.good");
    static CounterName counterPatchesBad = CounterName.register("RDFpatch-apply", "rdf-patch.apply.bad");
    private ContentType ctPatchText = WebContent.ctPatch;
    private ContentType ctPatchBinary = WebContent.ctPatchThrift;

    @Override
    public void validate(HttpAction action) {
        ContentType contentType;
        String method;
        switch (method = action.getRequest().getMethod()) {
            case "POST": 
            case "PATCH": {
                break;
            }
            default: {
                ServletOps.errorMethodNotAllowed(method + " : Patch must use POST or PATCH");
            }
        }
        String ctStr = action.getRequest().getContentType();
        String charset = action.getRequest().getCharacterEncoding();
        if (charset != null && !"utf-8".equalsIgnoreCase(charset)) {
            ServletOps.error(415, "Charset must be omitted or UTF-8, not " + charset);
        }
        if ("application/x-www-form-urlencoded".equals(ctStr)) {
            ctStr = null;
        }
        ContentType contentType2 = contentType = ctStr != null ? ContentType.create(ctStr) : this.ctPatchText;
        if (!this.ctPatchText.equals(contentType) && !this.ctPatchBinary.equals(contentType)) {
            ServletOps.error(415, "Allowed Content-types are " + this.ctPatchText + " or " + this.ctPatchBinary + ", not " + ctStr);
        }
        if (this.ctPatchBinary.equals(contentType)) {
            ServletOps.error(415, this.ctPatchBinary.getContentTypeStr() + " not supported yet");
        }
    }

    protected void operation(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), counterPatches);
        try {
            this.operation$(action);
            ActionExecLib.incCounter(action.getEndpoint(), counterPatchesGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), counterPatchesBad);
            throw ex;
        }
    }

    private void operation$(HttpAction action) {
        action.beginWrite();
        try {
            this.applyRDFPatch(action, WithPatchTxn.EXTERNAL_TXN);
            action.commit();
        }
        catch (PatchTxnAbortException ex) {
            action.abort();
            action.log.info(String.format("[%d] RDF Patch: abort in patch", action.id));
        }
        catch (Exception ex) {
            action.abort();
            throw ex;
        }
        finally {
            action.end();
        }
        ServletOps.success(action);
    }

    private void applyRDFPatch(HttpAction action, WithPatchTxn withPatchTxn) {
        try {
            String ct = action.getRequest().getContentType();
            ServletInputStream input = action.getRequest().getInputStream();
            DatasetGraph dsg = action.getDataset();
            RDFPatchReaderText pr = new RDFPatchReaderText(input);
            RDFChanges changes = new RDFChangesApply(dsg);
            if (withPatchTxn == WithPatchTxn.EXTERNAL_TXN) {
                changes = new RDFChangesExternalTxn(changes);
            }
            RDFChangesCounter counter = new RDFChangesCounter();
            RDFChanges dest = RDFChangesN.multi(changes, counter);
            pr.apply(dest);
            PatchSummary summary = counter.summary();
            if (summary.countAddPrefix > 0L || summary.countDeletePrefix > 0L) {
                action.log.info(String.format("[%d] RDF Patch: A=%d, D=%d, PA=%d, PD=%d", action.id, summary.countAddData, summary.countDeleteData, summary.countAddPrefix, summary.countDeletePrefix));
            } else {
                action.log.info(String.format("[%d] RDF Patch: A=%d, D=%d", action.id, summary.countAddData, summary.countDeleteData));
            }
            ServletOps.success(action);
        }
        catch (PatchTxnAbortException ex) {
            throw ex;
        }
        catch (PatchException ex) {
            throw ex;
        }
        catch (RiotException ex) {
            ServletOps.errorBadRequest("RDF Patch parse error: " + ex.getMessage());
        }
        catch (IOException ex) {
            ServletOps.errorBadRequest("IOException: " + ex.getMessage());
        }
    }

    @Override
    protected void doPost(HttpAction action) {
        this.operation(action);
    }

    @Override
    protected void doPatch(HttpAction action) {
        this.operation(action);
    }

    @Override
    protected void doOptions(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.getResponse().setHeader("Allow", "OPTIONS,POST,PATCH");
        action.getResponse().setHeader("Content-Length", "0");
    }

    @Override
    protected void doHead(HttpAction action) {
        ServletOps.errorMethodNotAllowed("HEAD");
    }

    @Override
    protected void doPut(HttpAction action) {
        ServletOps.errorMethodNotAllowed("PUT");
    }

    @Override
    protected void doDelete(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE");
    }

    @Override
    protected void doGet(HttpAction action) {
        ServletOps.errorMethodNotAllowed("GET");
    }

    private static enum WithPatchTxn {
        PATCH_TXN,
        EXTERNAL_TXN;

    }
}

