/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.fuseki.build.DatasetDescriptionMap;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.build.FusekiPrefixes;
import org.apache.jena.fuseki.ctl.ActionContainerItem;
import org.apache.jena.fuseki.ctl.JsonDescription;
import org.apache.jena.fuseki.mgt.TemplateFunctions;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.DataUploader;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.fuseki.webapp.FusekiWebapp;
import org.apache.jena.fuseki.webapp.SystemState;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.tdb1.sys.TDBInternal;
import org.apache.jena.tdb1.transaction.DatasetGraphTransaction;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.vocabulary.RDF;

public class ActionDatasets
extends ActionContainerItem {
    private static Dataset system = SystemState.getDataset();
    private static DatasetGraphTransaction systemDSG = SystemState.getDatasetGraph();
    private static Property pServiceName = FusekiVocab.pServiceName;
    private static final String paramDatasetName = "dbName";
    private static final String paramDatasetType = "dbType";
    private static final String tDatabaseTDB = "tdb";
    private static final String tDatabaseTDB2 = "tdb2";
    private static final String tDatabaseMem = "mem";
    private static Map<String, String> dbTypeToTemplate = new HashMap<String, String>();

    @Override
    public void validate(HttpAction action) {
    }

    @Override
    protected JsonValue execGetContainer(HttpAction action) {
        action.log.info(String.format("[%d] GET datasets", action.id));
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("D");
        builder.key("datasets");
        JsonDescription.arrayDatasets(builder, action.getDataAccessPointRegistry());
        builder.finishObject("D");
        return builder.build();
    }

    @Override
    protected JsonValue execGetItem(HttpAction action) {
        String item = ActionDatasets.getItemDatasetName(action);
        action.log.info(String.format("[%d] GET dataset %s", action.id, item));
        JsonBuilder builder = new JsonBuilder();
        DataAccessPoint dsDesc = ActionDatasets.getItemDataAccessPoint(action, item);
        if (dsDesc == null) {
            ServletOps.errorNotFound("Not found: dataset " + item);
        }
        JsonDescription.describe(builder, dsDesc);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected JsonValue execPostContainer(HttpAction action) {
        String configFile;
        String systemFileCopy;
        boolean committed;
        block43: {
            block44: {
                JsonValue jsonValue;
                block40: {
                    block41: {
                        block42: {
                            UUID uuid2 = UUID.randomUUID();
                            DatasetDescriptionMap registry = new DatasetDescriptionMap();
                            ContentType ct = ActionLib.getContentType(action);
                            boolean hasParams = action.getRequestParameterNames().hasMoreElements();
                            if (ct == null && !hasParams) {
                                ServletOps.errorBadRequest("Bad request - Content-Type or both parameters dbName and dbType required");
                            }
                            committed = false;
                            system.begin(ReadWrite.WRITE);
                            systemFileCopy = null;
                            configFile = null;
                            try {
                                String datasetName;
                                Model modelData = ModelFactory.createDefaultModel();
                                StreamRDF dest = StreamRDFLib.graph(modelData.getGraph());
                                if (hasParams || WebContent.isHtmlForm(ct)) {
                                    ActionDatasets.assemblerFromForm(action, dest);
                                } else if (WebContent.isMultiPartForm(ct)) {
                                    ActionDatasets.assemblerFromUpload(action, dest);
                                } else {
                                    ActionDatasets.assemblerFromBody(action, dest);
                                }
                                Model model = ModelFactory.createDefaultModel();
                                model.add(modelData);
                                AssemblerUtils.addRegistered(model);
                                systemFileCopy = FusekiWebapp.dirSystemFileArea.resolve(uuid2.toString()).toString();
                                try (OutputStream outCopy = IO.openOutputFile(systemFileCopy);){
                                    RDFDataMgr.write(outCopy, modelData, Lang.TURTLE);
                                }
                                Statement stmt = this.findService(model);
                                Resource subject = stmt.getSubject();
                                Literal object = stmt.getObject().asLiteral();
                                if (object.getDatatype() != null && !object.getDatatype().equals(XSDDatatype.XSDstring)) {
                                    action.log.warn(String.format("[%d] Service name '%s' is not a string", action.id, FmtUtils.stringForRDFNode(object)));
                                }
                                if ((datasetName = object.getLexicalForm()).isEmpty()) {
                                    ServletOps.error(400, "Empty dataset name");
                                }
                                if (StringUtils.isBlank(datasetName)) {
                                    ServletOps.error(400, String.format("Whitespace dataset name: '%s'", datasetName));
                                }
                                if (datasetName.contains(" ")) {
                                    ServletOps.error(400, String.format("Bad dataset name (contains spaces) '%s'", datasetName));
                                }
                                if (datasetName.equals("/")) {
                                    ServletOps.error(400, String.format("Bad dataset name '%s'", datasetName));
                                }
                                String datasetPath = DataAccessPoint.canonical(datasetName);
                                if (action.getDataAccessPointRegistry().isRegistered(datasetPath)) {
                                    ServletOps.error(409, "Name already registered " + datasetPath);
                                }
                                action.log.info(String.format("[%d] Create database : name = %s", action.id, datasetPath));
                                configFile = FusekiWebapp.generateConfigurationFilename(datasetPath);
                                List<String> existing = FusekiWebapp.existingConfigurationFile(datasetPath);
                                if (!existing.isEmpty()) {
                                    ServletOps.error(409, "Configuration file for '" + datasetPath + "' already exists");
                                }
                                try (OutputStream outCopy = IO.openOutputFile(configFile);){
                                    RDFDataMgr.write(outCopy, modelData, Lang.TURTLE);
                                }
                                DataAccessPoint dataAccessPoint = FusekiConfig.buildDataAccessPoint(subject, registry);
                                if (dataAccessPoint == null) {
                                    FmtLog.error(action.log, "Failed to build DataAccessPoint: datasetPath = %s; DataAccessPoint name = %s", datasetPath, dataAccessPoint);
                                    ServletOps.errorBadRequest("Failed to build DataAccessPoint");
                                    jsonValue = null;
                                    if (committed) break block40;
                                    if (systemFileCopy == null) break block41;
                                    break block42;
                                }
                                dataAccessPoint.getDataService().setEndpointProcessors(action.getOperationRegistry());
                                dataAccessPoint.getDataService().goActive();
                                if (!datasetPath.equals(dataAccessPoint.getName())) {
                                    FmtLog.warn(action.log, "Inconsistent names: datasetPath = %s; DataAccessPoint name = %s", datasetPath, dataAccessPoint);
                                }
                                action.getDataAccessPointRegistry().register(dataAccessPoint);
                                action.setResponseContentType("text/plain");
                                ServletOps.success(action);
                                system.commit();
                                committed = true;
                                if (committed) break block43;
                                break block44;
                            }
                            catch (IOException ex) {
                                IO.exception(ex);
                                return null;
                            }
                        }
                        FileOps.deleteSilent(systemFileCopy);
                    }
                    if (configFile != null) {
                        FileOps.deleteSilent(configFile);
                    }
                    system.abort();
                }
                system.end();
                return jsonValue;
            }
            if (systemFileCopy != null) {
                FileOps.deleteSilent(systemFileCopy);
            }
            if (configFile != null) {
                FileOps.deleteSilent(configFile);
            }
            system.abort();
        }
        system.end();
        return null;
        finally {
            if (!committed) {
                if (systemFileCopy != null) {
                    FileOps.deleteSilent(systemFileCopy);
                }
                if (configFile != null) {
                    FileOps.deleteSilent(configFile);
                }
                system.abort();
            }
            system.end();
        }
    }

    private Statement findService(Model model) {
        Statement stmt = ActionDatasets.getOne(model, null, pServiceName, null);
        if (stmt == null) {
            Statement stmt3;
            Statement stmt2 = ActionDatasets.getOne(model, null, RDF.type, FusekiVocab.fusekiService);
            if (stmt2 == null) {
                int count = model.listStatements(null, RDF.type, FusekiVocab.fusekiService).toList().size();
                if (count == 0) {
                    ServletOps.errorBadRequest("No triple rdf:type fuseki:Service found");
                } else {
                    ServletOps.errorBadRequest("Multiple Fuseki service descriptions");
                }
            }
            if ((stmt3 = ActionDatasets.getOne(model, stmt2.getSubject(), pServiceName, null)) == null) {
                StmtIterator sIter = model.listStatements(stmt2.getSubject(), pServiceName, (RDFNode)null);
                if (!sIter.hasNext()) {
                    ServletOps.errorBadRequest("No name given in description of Fuseki service");
                }
                sIter.next();
                if (sIter.hasNext()) {
                    ServletOps.errorBadRequest("Multiple names given in description of Fuseki service");
                }
                throw new InternalErrorException("Inconsistent: getOne didn't fail the second time");
            }
            stmt = stmt3;
        }
        if (!stmt.getObject().isLiteral()) {
            ServletOps.errorBadRequest("Found " + FmtUtils.stringForRDFNode(stmt.getObject()) + " : Service names are strings, then used to build the external URI");
        }
        return stmt;
    }

    @Override
    protected JsonValue execPostItem(HttpAction action) {
        String s2;
        DataService dSrv;
        String name = ActionDatasets.getItemDatasetName(action);
        if (name == null) {
            name = "''";
        }
        action.log.info(String.format("[%d] POST dataset %s", action.id, name));
        DataAccessPoint dap = ActionDatasets.getItemDataAccessPoint(action, name);
        if (dap == null) {
            ServletOps.errorNotFound("Not found: dataset " + name);
        }
        if ((dSrv = dap.getDataService()) == null) {
            dSrv = action.getDataAccessPoint().getDataService();
        }
        if ((s2 = action.getRequestParameter("state")) == null || s2.isEmpty()) {
            ServletOps.errorBadRequest("No state change given");
        }
        if (s2.equalsIgnoreCase("active")) {
            action.log.info(String.format("[%d] REBUILD DATASET %s", action.id, name));
            ActionDatasets.setDatasetState(name, FusekiVocab.stateActive);
            dSrv.goActive();
        } else if (s2.equalsIgnoreCase("offline")) {
            action.log.info(String.format("[%d] OFFLINE DATASET %s", action.id, name));
            dSrv.goOffline();
            ActionDatasets.setDatasetState(name, FusekiVocab.stateOffline);
        } else if (s2.equalsIgnoreCase("unlink")) {
            action.log.info(String.format("[%d] UNLINK ACCESS NAME %s", action.id, name));
            ServletOps.errorNotImplemented("unlink: dataset" + name);
        } else {
            ServletOps.errorBadRequest("State change operation '" + s2 + "' not recognized");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execDeleteItem(HttpAction action) {
        String name = ActionDatasets.getItemDatasetName(action);
        if (name == null) {
            name = "";
        }
        action.log.info(String.format("[%d] DELETE dataset=%s", action.id, name));
        if (!action.getDataAccessPointRegistry().isRegistered(name)) {
            ServletOps.errorNotFound("No such dataset registered: " + name);
        }
        systemDSG.begin(ReadWrite.WRITE);
        boolean committed = false;
        try {
            Path pDatabase;
            DataAccessPoint ref = action.getDataAccessPointRegistry().get(name);
            if (ref == null) {
                ServletOps.errorNotFound("No such dataset registered: " + name);
            }
            DataService dataService = ref.getDataService();
            action.getDataAccessPointRegistry().remove(name);
            String filename = name.startsWith("/") ? name.substring(1) : name;
            List<String> configurationFiles = FusekiWebapp.existingConfigurationFile(filename);
            if (configurationFiles.isEmpty()) {
                action.log.warn(String.format("[%d] Can't delete database configuration - not a managed database; dataset=%s", action.id, name));
                systemDSG.commit();
                committed = true;
                ServletOps.success(action);
                return;
            }
            if (configurationFiles.size() > 1) {
                action.log.warn(String.format("[%d] There are %d configuration files, not one.", action.id, configurationFiles.size()));
                ServletOps.errorOccurred(String.format("There are %d configuration files, not one. Delete not performed; clearup of the filesystem needed.", configurationFiles.size()));
                return;
            }
            String cfgPathname = configurationFiles.get(0);
            FileOps.deleteSilent(cfgPathname);
            boolean isTDB1 = TDBInternal.isTDB1(dataService.getDataset());
            boolean isTDB2 = org.apache.jena.tdb2.sys.TDBInternal.isTDB2(dataService.getDataset());
            try {
                dataService.shutdown();
            }
            catch (TransactionException transactionException) {
                // empty catch block
            }
            if ((isTDB1 || isTDB2) && Files.exists(pDatabase = FusekiWebapp.dirDatabases.resolve(filename), new LinkOption[0])) {
                try {
                    if (Files.isSymbolicLink(pDatabase)) {
                        action.log.info(String.format("[%d] Database is a symbolic link, not removing files %s", action.id, pDatabase));
                    } else {
                        IO.deleteAll(pDatabase);
                        action.log.info(String.format("[%d] Deleted database files %s", action.id, pDatabase));
                    }
                }
                catch (RuntimeIOException ex) {
                    action.log.error(String.format("[%d] Error while deleting database files %s: %s", action.id, pDatabase, ex.getMessage()), ex);
                }
            }
            Node n = NodeFactory.createLiteralString(DataAccessPoint.canonical(name));
            Quad q = ActionDatasets.getOne(systemDSG, null, null, pServiceName.asNode(), n);
            if (q != null) {
                Node gn = q.getGraph();
                systemDSG.deleteAny(gn, null, null, null);
            }
            systemDSG.commit();
            committed = true;
            ServletOps.success(action);
        }
        finally {
            if (!committed) {
                systemDSG.abort();
            }
            systemDSG.end();
        }
    }

    private static void assemblerFromBody(HttpAction action, StreamRDF dest) {
        ActionDatasets.bodyAsGraph(action, dest);
    }

    private static void assemblerFromForm(HttpAction action, StreamRDF dest) {
        String x = action.getRequestQueryString();
        String dbType = action.getRequestParameter(paramDatasetType);
        String dbName = action.getRequestParameter(paramDatasetName);
        if (StringUtils.isBlank(dbType) || StringUtils.isBlank(dbName)) {
            ServletOps.errorBadRequest("Received HTML form.  Both parameters 'dbName' and 'dbType' required");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (dbName.startsWith("/")) {
            params.put("NAME", dbName.substring(1));
        } else {
            params.put("NAME", dbName);
        }
        FusekiWebapp.addGlobals(params);
        String template = dbTypeToTemplate.get(Lib.lowercase(dbType));
        if (template == null) {
            ServletOps.errorBadRequest(String.format("dbType can be only '%s', '%s' or '%s'", tDatabaseTDB, tDatabaseTDB2, tDatabaseMem));
        }
        String syntax = TemplateFunctions.templateFile(template, params, Lang.TTL);
        RDFParser.create().source(new StringReader(syntax)).base("http://base/").lang(Lang.TTL).parse(dest);
    }

    private static void assemblerFromUpload(HttpAction action, StreamRDF dest) {
        DataUploader.incomingData(action, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setDatasetState(String name, Resource newState) {
        boolean committed = false;
        system.begin(ReadWrite.WRITE);
        try {
            String dbName = name;
            if (dbName.startsWith("/")) {
                dbName = dbName.substring(1);
            }
            String update2 = StrUtils.strjoinNL(FusekiPrefixes.PREFIXES, "DELETE { GRAPH ?g { ?s fu:status ?state } }", "INSERT { GRAPH ?g { ?s fu:status " + FmtUtils.stringForRDFNode(newState) + " } }", "WHERE {", "   GRAPH ?g { ?s fu:name '" + dbName + "'; ", "                 fu:status ?state .", "   }", "}");
            UpdateRequest req = UpdateFactory.create(update2);
            UpdateAction.execute(req, system);
            system.commit();
            committed = true;
        }
        finally {
            if (!committed) {
                system.abort();
            }
            system.end();
        }
    }

    private static Quad getOne(DatasetGraph dsg, Node g2, Node s2, Node p, Node o) {
        Iterator<Quad> iter = dsg.findNG(g2, s2, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Quad q = iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return q;
    }

    private static Statement getOne(Model m4, Resource s2, Property p, RDFNode o) {
        StmtIterator iter = m4.listStatements(s2, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Statement stmt = (Statement)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return stmt;
    }

    private static void bodyAsGraph(HttpAction action, StreamRDF dest) {
        HttpServletRequest request = action.getRequest();
        String base = ActionLib.wholeRequestURL(request);
        ContentType ct = FusekiNetLib.getContentType(request);
        Lang lang = RDFLanguages.contentTypeToLang(ct.getContentTypeStr());
        if (lang == null) {
            ServletOps.errorBadRequest("Unknown content type for triples: " + ct);
            return;
        }
        dest.prefix("root", base + "#");
        ActionLib.parseOrError(action, dest, lang, base);
    }

    static {
        dbTypeToTemplate.put(tDatabaseTDB, "templates/config-tdb");
        dbTypeToTemplate.put(tDatabaseTDB2, "templates/config-tdb2");
        dbTypeToTemplate.put(tDatabaseMem, "templates/config-mem");
    }
}

