/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.simple;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.dboe.storage.StorageRDF;
import org.apache.jena.dboe.storage.simple.StorageTuplesN;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

public abstract class StorageTuples
implements StorageRDF {
    private final StorageTuplesN triples;
    private final StorageTuplesN quads;

    protected StorageTuples(StorageTuplesN triples, StorageTuplesN quads) {
        if (triples.N != 3) {
            throw new IllegalArgumentException("Triples storage is not for tuples of length 3: provided length is " + triples.N);
        }
        if (quads.N != 4) {
            throw new IllegalArgumentException("Quads storage is not for tuples of length 4: provided length is " + quads.N);
        }
        this.triples = triples;
        this.quads = quads;
    }

    @Override
    public void add(Node s2, Node p, Node o) {
        this.triples.add(StorageTuples.tuple(s2, p, o));
    }

    @Override
    public void add(Node g2, Node s2, Node p, Node o) {
        this.quads.add(StorageTuples.tuple(g2, s2, p, o));
    }

    @Override
    public void delete(Node s2, Node p, Node o) {
        this.triples.delete(StorageTuples.tuple(s2, p, o));
    }

    @Override
    public void delete(Node g2, Node s2, Node p, Node o) {
        this.quads.delete(StorageTuples.tuple(g2, s2, p, o));
    }

    private static Tuple<Node> tuple(Node ... n) {
        return TupleFactory.create(n);
    }

    private static Triple triple(Tuple<Node> tuple) {
        StorageTuples.check(3, tuple);
        return Triple.create(tuple.get(0), tuple.get(1), tuple.get(2));
    }

    private static Quad quad(Tuple<Node> tuple) {
        StorageTuples.check(4, tuple);
        return Quad.create(tuple.get(0), tuple.get(1), tuple.get(2), tuple.get(3));
    }

    private static void check(int N2, Tuple<Node> terms) {
        if (terms.len() != N2) {
            throw new IllegalArgumentException("Length " + terms.len() + " : expected " + N2);
        }
    }

    @Override
    public void removeAll(Node s2, Node p, Node o) {
        this.triples.removeAll(StorageTuples.tuple(s2, p, o));
    }

    @Override
    public void removeAll(Node g2, Node s2, Node p, Node o) {
        this.quads.removeAll(StorageTuples.tuple(g2, s2, p, o));
    }

    @Override
    public Iterator<Triple> find(Node s2, Node p, Node o) {
        return this.stream(s2, p, o).iterator();
    }

    @Override
    public Iterator<Quad> find(Node g2, Node s2, Node p, Node o) {
        return this.stream(g2, s2, p, o).iterator();
    }

    @Override
    public Stream<Triple> stream(Node s2, Node p, Node o) {
        return this.triples.find(StorageTuples.tuple(s2, p, o)).map(StorageTuples::triple);
    }

    @Override
    public Stream<Quad> stream(Node g2, Node s2, Node p, Node o) {
        return this.quads.find(StorageTuples.tuple(g2, s2, p, o)).map(StorageTuples::quad);
    }

    @Override
    public boolean contains(Node s2, Node p, Node o) {
        return this.triples.contain(StorageTuples.tuple(s2, p, o));
    }

    @Override
    public boolean contains(Node g2, Node s2, Node p, Node o) {
        return this.quads.contain(StorageTuples.tuple(g2, s2, p, o));
    }
}

