/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PatternOptionBuilder;

public class TypeHandler {
    public static Class<?> createClass(String className) throws ParseException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            throw new ParseException("Unable to find the class: " + className);
        }
    }

    public static Date createDate(String str2) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static File createFile(String str2) {
        return new File(str2);
    }

    public static File[] createFiles(String str2) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static Number createNumber(String str2) throws ParseException {
        try {
            if (str2.indexOf(46) != -1) {
                return Double.valueOf(str2);
            }
            return Long.valueOf(str2);
        }
        catch (NumberFormatException e2) {
            throw new ParseException(e2.getMessage());
        }
    }

    public static Object createObject(String className) throws ParseException {
        Class<?> cl;
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ParseException("Unable to find the class: " + className);
        }
        try {
            return cl.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new ParseException(e2.getClass().getName() + "; Unable to create an instance of: " + className);
        }
    }

    public static URL createURL(String str2) throws ParseException {
        try {
            return new URL(str2);
        }
        catch (MalformedURLException e2) {
            throw new ParseException("Unable to parse the URL: " + str2);
        }
    }

    public static <T> T createValue(String str2, Class<T> clazz) throws ParseException {
        if (PatternOptionBuilder.STRING_VALUE == clazz) {
            return (T)str2;
        }
        if (PatternOptionBuilder.OBJECT_VALUE == clazz) {
            return (T)TypeHandler.createObject(str2);
        }
        if (PatternOptionBuilder.NUMBER_VALUE == clazz) {
            return (T)TypeHandler.createNumber(str2);
        }
        if (PatternOptionBuilder.DATE_VALUE == clazz) {
            return (T)TypeHandler.createDate(str2);
        }
        if (PatternOptionBuilder.CLASS_VALUE == clazz) {
            return (T)TypeHandler.createClass(str2);
        }
        if (PatternOptionBuilder.FILE_VALUE == clazz) {
            return (T)TypeHandler.createFile(str2);
        }
        if (PatternOptionBuilder.EXISTING_FILE_VALUE == clazz) {
            return (T)TypeHandler.openFile(str2);
        }
        if (PatternOptionBuilder.FILES_VALUE == clazz) {
            return (T)TypeHandler.createFiles(str2);
        }
        if (PatternOptionBuilder.URL_VALUE == clazz) {
            return (T)TypeHandler.createURL(str2);
        }
        throw new ParseException("Unable to handle the class: " + clazz);
    }

    public static Object createValue(String str2, Object obj) throws ParseException {
        return TypeHandler.createValue(str2, (Class)obj);
    }

    public static FileInputStream openFile(String str2) throws ParseException {
        try {
            return new FileInputStream(str2);
        }
        catch (FileNotFoundException e2) {
            throw new ParseException("Unable to find file: " + str2);
        }
    }
}

